/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.gav;

import eu.maveniverse.maven.toolbox.plugin.GavMojoSupport;
import eu.maveniverse.maven.toolbox.shared.ResolutionScope;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import java.util.List;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import picocli.CommandLine;

@CommandLine.Command(name="resolve-transitive", description={"Resolves Maven Artifacts transitively"})
@Mojo(name="gav-resolve-transitive", requiresProject=false, threadSafe=true)
public class GavResolveTransitiveMojo
extends GavMojoSupport {
    @CommandLine.Parameters(index="0", description={"The comma separated GAVs to resolve"}, arity="1")
    @Parameter(property="gav", required=true)
    private String gav;
    @CommandLine.Option(names={"--scope"}, defaultValue="runtime", description={"Resolution scope to resolve (default 'runtime')"})
    @Parameter(property="scope", defaultValue="runtime", required=true)
    private String scope;
    @CommandLine.Option(names={"--boms"}, defaultValue="", description={"Comma separated list of BOMs to apply"})
    @Parameter(property="boms")
    private String boms;
    @CommandLine.Option(names={"--sources"}, description={"Resolve sources JAR as well (derive coordinates from GAV)"})
    @Parameter(property="sources", defaultValue="false")
    private boolean sources;
    @CommandLine.Option(names={"--javadoc"}, description={"Resolve javadoc JAR as well (derive coordinates from GAV)"})
    @Parameter(property="javadoc", defaultValue="false")
    private boolean javadoc;
    @CommandLine.Option(names={"--signature"}, description={"Resolve GnuPG signature as well (derive coordinates from GAV)"})
    @Parameter(property="signature", defaultValue="false")
    private boolean signature;
    @CommandLine.Option(names={"--sinkSpec"}, defaultValue="null()", description={"The sink spec (default 'null()')"})
    @Parameter(property="sinkSpec", defaultValue="null()", required=true)
    private String sinkSpec;

    protected Result<List<Artifact>> doExecute() throws Exception {
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        return toolboxCommando.resolveTransitive(ResolutionScope.parse((String)this.scope), toolboxCommando.loadGavs(this.slurp(this.gav), this.slurp(this.boms)), this.sources, this.javadoc, this.signature, toolboxCommando.artifactSink(this.sinkSpec));
    }
}

