/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.gav;

import eu.maveniverse.maven.toolbox.plugin.GavSearchMojoSupport;
import eu.maveniverse.maven.toolbox.shared.ResolutionScope;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import picocli.CommandLine;

@CommandLine.Command(name="libyear", description={"Calculates libyear for artifacts."})
@Mojo(name="gav-libyear", requiresProject=false, threadSafe=true)
public class GavLibYearMojo
extends GavSearchMojoSupport {
    @CommandLine.Parameters(index="0", description={"The GAV to show libyear for"}, arity="1")
    @Parameter(property="gav", required=true)
    private String gav;
    @CommandLine.Option(names={"--scope"}, defaultValue="test", description={"Resolution scope to resolve (default 'test')"})
    @Parameter(property="scope", defaultValue="test", required=true)
    private String scope;
    @CommandLine.Option(names={"--boms"}, defaultValue="", description={"Comma separated list of BOMs to apply"})
    @Parameter(property="boms")
    private String boms;
    @CommandLine.Option(names={"--artifactVersionMatcherSpec"}, defaultValue="noSnapshotsAndPreviews()", description={"Artifact version matcher spec (default 'noSnapshotsAndPreviews()')"})
    @Parameter(property="artifactVersionMatcherSpec", defaultValue="noSnapshotsAndPreviews()")
    private String artifactVersionMatcherSpec;
    @CommandLine.Option(names={"--artifactVersionSelectorSpec"}, defaultValue="major()", description={"Artifact version selector spec (default 'major()')"})
    @Parameter(property="artifactVersionSelectorSpec", defaultValue="major()")
    private String artifactVersionSelectorSpec;
    @CommandLine.Option(names={"--transitive"}, description={"Make command transitive"})
    @Parameter(property="transitive", defaultValue="false")
    private boolean transitive;
    @CommandLine.Option(names={"--upToDate"}, description={"Make libyear show up-to-date libraries with age as well"})
    @Parameter(property="upToDate", defaultValue="false")
    private boolean upToDate;

    protected Result<Float> doExecute() throws Exception {
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        return toolboxCommando.libYear("GAV " + this.gav, ResolutionScope.parse((String)this.scope), toolboxCommando.loadGav(this.gav, this.slurp(this.boms)), this.transitive, this.upToDate, (Predicate)toolboxCommando.parseArtifactVersionMatcherSpec(this.artifactVersionMatcherSpec), (BiFunction)toolboxCommando.parseArtifactVersionSelectorSpec(this.artifactVersionSelectorSpec), this.repositoryVendor);
    }
}

