/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.gav;

import eu.maveniverse.maven.toolbox.plugin.GavMojoSupport;
import eu.maveniverse.maven.toolbox.shared.ResolutionScope;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.collection.CollectResult;
import picocli.CommandLine;

@CommandLine.Command(name="dirty-tree", description={"Displays dirty tree of Maven Artifact"})
@Mojo(name="gav-dirty-tree", requiresProject=false, threadSafe=true)
public class GavDirtyTreeMojo
extends GavMojoSupport {
    @CommandLine.Parameters(index="0", description={"The GAV to show tree for"}, arity="1")
    @Parameter(property="gav", required=true)
    private String gav;
    @CommandLine.Option(names={"--scope"}, defaultValue="runtime", description={"Resolution scope to resolve (default 'runtime')"})
    @Parameter(property="scope", defaultValue="runtime", required=true)
    private String scope;
    @CommandLine.Option(names={"--boms"}, defaultValue="", description={"Comma separated list of BOMs to apply"})
    @Parameter(property="boms")
    private String boms;
    @Parameter(property="dependencyMatcher", defaultValue="any()", required=true)
    private String dependencyMatcher;
    @CommandLine.Option(names={"--verboseTree"}, defaultValue="false", description={"Make it true for verbose tree"})
    @Parameter(property="verboseTree", defaultValue="false", required=true)
    private boolean verboseTree;
    @CommandLine.Option(names={"--dirtyLevel"}, defaultValue="3", description={"Set the level you want to see dirty tree up to"})
    @Parameter(property="dirtyLevel", defaultValue="3", required=true)
    private int dirtyLevel;

    protected Result<CollectResult> doExecute() throws Exception {
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        return toolboxCommando.dirtyTree(ResolutionScope.parse((String)this.scope), toolboxCommando.loadGav(this.gav, this.slurp(this.boms)), this.dirtyLevel, this.verboseTree, toolboxCommando.parseDependencyMatcherSpec(this.dependencyMatcher));
    }
}

