/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin;

import eu.maveniverse.maven.toolbox.shared.ProjectLocator;
import eu.maveniverse.maven.toolbox.shared.ReactorLocator;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Parent;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;

public class MavenReactorLocator
implements ReactorLocator {
    private final ProjectLocator.Project topLevel;
    private final ProjectLocator.Project current;
    private final List<ProjectLocator.Project> allProjects;

    public MavenReactorLocator(MavenSession session) {
        Objects.requireNonNull(session, "session");
        this.allProjects = session.getAllProjects().stream().map(p -> this.convert(session.getRepositorySession(), (MavenProject)p)).toList();
        this.topLevel = this.locateProject(RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)session.getTopLevelProject().getArtifact())).orElseThrow();
        this.current = this.locateProject(RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)session.getCurrentProject().getArtifact())).orElseThrow();
    }

    private ProjectLocator.Project convert(RepositorySystemSession session, MavenProject project) {
        Objects.requireNonNull(project, "project");
        Artifact pa = RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)project.getArtifact());
        DefaultArtifact pp = null;
        if (project.getModel().getParent() != null) {
            Parent parent = project.getModel().getParent();
            pp = new DefaultArtifact(parent.getGroupId(), parent.getArtifactId(), "pom", parent.getVersion());
        }
        List<Dependency> pd = project.getModel().getDependencies().stream().map(d -> RepositoryUtils.toDependency((org.apache.maven.model.Dependency)d, (ArtifactTypeRegistry)session.getArtifactTypeRegistry())).toList();
        List<Artifact> collected = project.getCollectedProjects().stream().map(p -> RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)p.getArtifact())).toList();
        return new MProject(pa, (Artifact)pp, pd, collected, (ProjectLocator)this);
    }

    public ProjectLocator.Project getTopLevelProject() {
        return this.topLevel;
    }

    public ProjectLocator.Project getCurrentProject() {
        return this.current;
    }

    public List<ProjectLocator.Project> getAllProjects() {
        return this.allProjects;
    }

    public Optional<ProjectLocator.Project> locateProject(Artifact artifact) {
        return this.allProjects.stream().filter(p -> ArtifactIdUtils.equalsId((Artifact)p.artifact(), (Artifact)artifact)).findFirst();
    }

    public List<ProjectLocator.Project> locateChildren(ProjectLocator.Project project) {
        return this.allProjects.stream().filter(p -> {
            Optional parentArtifact = p.getParent();
            return parentArtifact.isPresent() && ArtifactIdUtils.equalsId((Artifact)((Artifact)parentArtifact.orElseThrow()), (Artifact)project.artifact());
        }).toList();
    }

    public List<ProjectLocator.Project> locateCollected(ProjectLocator.Project project) {
        if (project instanceof MProject) {
            MProject mProject = (MProject)project;
            List<ProjectLocator.Project> allOfGrandchildren = mProject.collected().stream().map(this::locateProject).filter(Optional::isPresent).map(Optional::get).filter(p -> MProject.class.isAssignableFrom(p.getClass())).map(p -> ((MProject)p).collected()).flatMap(Collection::stream).map(this::locateProject).filter(Optional::isPresent).map(Optional::get).toList();
            return mProject.collected().stream().map(this::locateProject).filter(Optional::isPresent).map(Optional::get).toList().stream().filter(p -> !allOfGrandchildren.contains(p)).toList();
        }
        return List.of();
    }

    public Stream<Artifact> get() {
        return this.getAllProjects().stream().map(ProjectLocator.Project::artifact);
    }

    private static final class MProject
    implements ProjectLocator.Project {
        private final Artifact artifact;
        private final Artifact parent;
        private final List<Dependency> dependencies;
        private final List<Artifact> collected;
        private final ProjectLocator origin;

        private MProject(Artifact artifact, Artifact parent, List<Dependency> dependencies, List<Artifact> collected, ProjectLocator origin) {
            this.artifact = Objects.requireNonNull(artifact, "artifact");
            this.parent = parent;
            this.dependencies = Objects.requireNonNull(dependencies, "dependencies");
            this.collected = Objects.requireNonNull(collected, "collected");
            this.origin = origin;
        }

        public Optional<Artifact> getParent() {
            return Optional.ofNullable(this.parent);
        }

        public Artifact artifact() {
            return this.artifact;
        }

        public Artifact parent() {
            return this.parent;
        }

        public List<Dependency> dependencies() {
            return this.dependencies;
        }

        public List<Artifact> collected() {
            return this.collected;
        }

        public ProjectLocator origin() {
            return this.origin;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MProject mProject = (MProject)o;
            return Objects.equals(this.artifact, mProject.artifact) && Objects.equals(this.parent, mProject.parent) && Objects.equals(this.dependencies, mProject.dependencies) && Objects.equals(this.collected, mProject.collected) && Objects.equals(this.origin, mProject.origin);
        }

        public int hashCode() {
            return Objects.hash(this.artifact, this.parent, this.dependencies, this.collected, this.origin);
        }
    }
}

