/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin;

import eu.maveniverse.maven.toolbox.plugin.GavMojoSupport;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.repository.RemoteRepository;
import picocli.CommandLine;

public abstract class GavSearchMojoSupport
extends GavMojoSupport {
    @CommandLine.Option(names={"--repositoryId"}, defaultValue="central", description={"A repository ID. Maybe a 'well known' one, or if all repository data given, a new one"})
    @Parameter(property="repositoryId", defaultValue="central")
    protected String repositoryId;
    @CommandLine.Option(names={"--repositoryBaseUri"}, description={"The base URI of the remote repository"})
    @Parameter(property="repositoryBaseUri")
    protected String repositoryBaseUri;
    @CommandLine.Option(names={"--repositoryVendor"}, description={"The vendor of the remote repository"})
    @Parameter(property="repositoryVendor", alias="toolbox.search.backend.type")
    protected String repositoryVendor;

    protected RemoteRepository getRemoteRepository(ToolboxCommando toolboxCommando) {
        RemoteRepository remoteRepository = (RemoteRepository)toolboxCommando.getKnownSearchRemoteRepositories().get(this.repositoryId);
        if (remoteRepository != null) {
            return remoteRepository;
        }
        if (this.repositoryBaseUri == null && this.repositoryVendor == null) {
            throw new IllegalArgumentException("for new remote repository one must specify all information");
        }
        return toolboxCommando.parseRemoteRepository(this.repositoryId + "::" + this.repositoryVendor + "::" + this.repositoryBaseUri);
    }
}

