/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.gav;

import eu.maveniverse.maven.toolbox.plugin.GavMojoSupport;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import java.util.List;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.graph.Dependency;
import picocli.CommandLine;

@CommandLine.Command(name="dm-list", description={"Displays dependency management list of Maven Artifact"})
@Mojo(name="gav-dm-list", requiresProject=false, threadSafe=true)
public class GavDmListMojo
extends GavMojoSupport {
    @CommandLine.Parameters(index="0", description={"The GAV to show dependency management list for"}, arity="1")
    @Parameter(property="gav", required=true)
    private String gav;
    @CommandLine.Option(names={"--boms"}, defaultValue="", description={"Comma separated list of BOMs to apply"})
    @Parameter(property="boms")
    private String boms;
    @CommandLine.Option(names={"--verboseList"}, defaultValue="false", description={"Make it true for verbose list"})
    @Parameter(property="verboseList", defaultValue="false", required=true)
    private boolean verboseList;

    protected Result<List<Dependency>> doExecute() throws Exception {
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        return toolboxCommando.dmList(toolboxCommando.loadGav(this.gav, this.slurp(this.boms)), this.verboseList);
    }
}

