/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin;

import eu.maveniverse.maven.toolbox.plugin.MavenReactorLocator;
import eu.maveniverse.maven.toolbox.plugin.MojoSupport;
import eu.maveniverse.maven.toolbox.shared.DependencyMatcher;
import eu.maveniverse.maven.toolbox.shared.ReactorLocator;
import eu.maveniverse.maven.toolbox.shared.ResolutionRoot;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;

public abstract class MPMojoSupport
extends MojoSupport {
    @Component
    protected MavenSession mavenSession;
    @Component
    protected MavenProject mavenProject;
    @Component
    protected ArtifactHandlerManager artifactHandlerManager;
    @Parameter(property="toolbox.search.backend.type")
    private String repositoryVendor;

    protected String getRepositoryVendor() {
        if (this.repositoryVendor != null) {
            return this.repositoryVendor;
        }
        return this.mavenProject.getProperties().getProperty("toolbox.search.backend.type");
    }

    protected List<Dependency> toDependencies(List<org.apache.maven.model.Dependency> dependencies) {
        ArtifactTypeRegistry artifactTypeRegistry = this.mavenSession.getRepositorySession().getArtifactTypeRegistry();
        return dependencies.stream().map(d -> RepositoryUtils.toDependency((org.apache.maven.model.Dependency)d, (ArtifactTypeRegistry)artifactTypeRegistry)).collect(Collectors.toList());
    }

    protected ResolutionRoot projectAsResolutionRoot() {
        ResolutionRoot.Builder builder = ResolutionRoot.ofNotLoaded((Artifact)new DefaultArtifact(this.mavenProject.getGroupId(), this.mavenProject.getArtifactId(), this.artifactHandlerManager.getArtifactHandler(this.mavenProject.getPackaging()).getExtension(), this.mavenProject.getVersion())).withDependencies(this.toDependencies(this.mavenProject.getDependencies()));
        if (this.mavenProject.getDependencyManagement() != null) {
            builder.withManagedDependencies(this.toDependencies(this.mavenProject.getDependencyManagement().getDependencies()));
        }
        return builder.build();
    }

    protected List<ResolutionRoot> projectManagedDependenciesAsResolutionRoots(DependencyMatcher dependencyMatcher) {
        ResolutionRoot project = this.projectAsResolutionRoot();
        return project.getManagedDependencies().stream().filter(d -> !this.isReactorDependency((Dependency)d)).filter((Predicate<Dependency>)dependencyMatcher).map(d -> ResolutionRoot.ofLoaded((Artifact)this.getToolboxCommando().toArtifact(d)).build()).collect(Collectors.toList());
    }

    protected List<ResolutionRoot> projectDependenciesAsResolutionRoots(DependencyMatcher dependencyMatcher) {
        ResolutionRoot project = this.projectAsResolutionRoot();
        return project.getDependencies().stream().filter(d -> !this.isReactorDependency((Dependency)d)).filter((Predicate<Dependency>)dependencyMatcher).map(d -> ResolutionRoot.ofLoaded((Artifact)this.getToolboxCommando().toArtifact(d)).withManagedDependencies(project.getManagedDependencies()).build()).collect(Collectors.toList());
    }

    protected boolean isReactorDependency(Dependency dependency) {
        return this.mavenSession.getAllProjects().stream().anyMatch(p -> Objects.equals(p.getGroupId(), dependency.getArtifact().getGroupId()) && Objects.equals(p.getArtifactId(), dependency.getArtifact().getArtifactId()) && Objects.equals(p.getVersion(), dependency.getArtifact().getVersion()));
    }

    protected ReactorLocator getReactorLocator() {
        return new MavenReactorLocator(this.mavenSession);
    }
}

