/*
 * Decompiled with CFR 0.152.
 */
package eu.markov.jenkins.plugin.mvnmeta;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import eu.markov.jenkins.plugin.mvnmeta.MavenMetadataParameterDefinitionBackwardCompatibility;
import eu.markov.jenkins.plugin.mvnmeta.MavenMetadataParameterValue;
import eu.markov.jenkins.plugin.mvnmeta.MavenMetadataVersions;
import hudson.Extension;
import hudson.Util;
import hudson.cli.CLICommand;
import hudson.model.ItemGroup;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class MavenMetadataParameterDefinition
extends MavenMetadataParameterDefinitionBackwardCompatibility {
    private static final long serialVersionUID = -4776115854285459316L;
    private static final String DEFAULT_FIRST = "FIRST";
    private static final String DEFAULT_LAST = "LAST";
    private static final String DEFAULT_LATEST = "LATEST";
    private static final String DEFAULT_RELEASE = "RELEASE";
    private static final Pattern MATCH_ALL = Pattern.compile(".*");
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private transient Integer maxVers = null;
    private transient Pattern versionFilterPattern = null;
    private final String repoBaseUrl;
    private final String groupId;
    private final String artifactId;
    private final String packaging;
    private final String classifier;
    private final String defaultValue;
    private final String versionFilter;
    private final SortOrder sortOrder;
    private final String maxVersions;
    private final String currentArtifactInfoUrl;
    private final String currentArtifactInfoLabel;
    private final String currentArtifactInfoPattern;
    private String credentialsId;
    private static final Logger LOGGER = Logger.getLogger(MavenMetadataParameterDefinition.class.getName());

    @DataBoundConstructor
    public MavenMetadataParameterDefinition(String name, String description, String repoBaseUrl, String groupId, String artifactId, String packaging, String classifier, String versionFilter, String sortOrder, String defaultValue, String maxVersions, String currentArtifactInfoUrl, String currentArtifactInfoLabel, String currentArtifactInfoPattern, String credentialsId) {
        super(name, description);
        this.repoBaseUrl = Util.removeTrailingSlash((String)repoBaseUrl);
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.packaging = packaging;
        this.classifier = classifier;
        this.versionFilter = StringUtils.trim((String)versionFilter);
        this.sortOrder = SortOrder.valueOf(sortOrder);
        this.defaultValue = StringUtils.trim((String)defaultValue);
        this.maxVersions = maxVersions;
        this.currentArtifactInfoUrl = currentArtifactInfoUrl;
        this.currentArtifactInfoLabel = currentArtifactInfoLabel;
        this.currentArtifactInfoPattern = currentArtifactInfoPattern;
        this.credentialsId = credentialsId;
    }

    public int getMaxVers() {
        if (this.maxVers == null) {
            try {
                this.maxVers = Integer.parseInt(this.maxVersions);
            }
            catch (NumberFormatException e) {
                this.maxVers = Integer.MAX_VALUE;
            }
        }
        return this.maxVers;
    }

    public Pattern getVersionFilterPattern() {
        if (this.versionFilterPattern == null) {
            this.versionFilterPattern = StringUtils.isNotBlank((String)this.versionFilter) ? Pattern.compile(this.versionFilter) : MATCH_ALL;
        }
        return this.versionFilterPattern;
    }

    public String getPackaging() {
        if (StringUtils.isNotBlank((String)this.packaging)) {
            return this.packaging;
        }
        return "jar";
    }

    public String getClassifier() {
        if (StringUtils.isNotBlank((String)this.classifier)) {
            return this.classifier;
        }
        return "";
    }

    private ParameterValue createValue(String version) {
        return new MavenMetadataParameterValue(this.getName(), this.getDescription(), this.getGroupId(), this.getArtifactId(), version, this.getPackaging(), this.getClassifier(), this.getFullArtifactUrl(this.getGroupId(), this.getArtifactId(), version, this.getPackaging(), this.getClassifier()));
    }

    public ParameterValue createValue(CLICommand command, String version) {
        return this.createValue(version);
    }

    public ParameterValue createValue(StaplerRequest req) {
        String[] values = req.getParameterValues(this.getName());
        if (values == null || values.length != 1) {
            return this.getDefaultParameterValue();
        }
        String version = values[0];
        return this.createValue(version);
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject formData) {
        MavenMetadataParameterValue value = (MavenMetadataParameterValue)((Object)req.bindJSON(MavenMetadataParameterValue.class, formData));
        value.setDescription(this.getDescription());
        value.setArtifactUrl(this.getFullArtifactUrl(value));
        return value;
    }

    public ParameterValue getDefaultParameterValue() {
        String defaultVersion = null;
        if (DEFAULT_FIRST.equals(this.defaultValue)) {
            List<String> allVersions = this.getArtifactMetadata().versioning.versions;
            if (allVersions.size() > 0) {
                defaultVersion = allVersions.get(0);
            }
        } else if (DEFAULT_LAST.equals(this.defaultValue)) {
            List<String> allVersions = this.getArtifactMetadata().versioning.versions;
            if (allVersions != null && allVersions.size() > 0) {
                defaultVersion = allVersions.get(allVersions.size() - 1);
            }
        } else {
            defaultVersion = DEFAULT_LATEST.equals(this.defaultValue) ? this.getArtifactMetadata().versioning.latest : (DEFAULT_RELEASE.equals(this.defaultValue) ? this.getArtifactMetadata().versioning.release : this.defaultValue);
        }
        if (StringUtils.isBlank(defaultVersion)) {
            return null;
        }
        return new MavenMetadataParameterValue(this.getName(), this.getDescription(), this.getGroupId(), this.getArtifactId(), defaultVersion, this.getPackaging(), this.getClassifier(), this.getFullArtifactUrl(this.getGroupId(), this.getArtifactId(), defaultVersion, this.getPackaging(), this.getClassifier()));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public List<String> getVersions() {
        return this.getArtifactMetadata().versioning.versions;
    }

    public String getCurrentArtifactInfo() {
        StringBuilder currentArtifactInfoBuilder = new StringBuilder("");
        if (StringUtils.isNotBlank((String)this.currentArtifactInfoUrl)) {
            if (StringUtils.isBlank((String)this.currentArtifactInfoLabel)) {
                currentArtifactInfoBuilder.append("Currently used artifact");
            } else {
                currentArtifactInfoBuilder.append(this.currentArtifactInfoLabel);
            }
            currentArtifactInfoBuilder.append(": ");
            try {
                currentArtifactInfoBuilder.append(this.getCurrentArtifactInfoInternal());
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, "Request of current artifact info failed", ioe);
                currentArtifactInfoBuilder.append("(Request failed)");
            }
        }
        return currentArtifactInfoBuilder.toString();
    }

    private String getCurrentArtifactInfoInternal() throws IOException {
        Pattern pattern;
        Matcher matcher;
        URL url = new URL(this.currentArtifactInfoUrl);
        LOGGER.finest("Requesting current artifact info from URL: " + url.toExternalForm());
        URLConnection connection = url.openConnection();
        InputStream inputStream = connection.getInputStream();
        String contentEncoding = connection.getContentEncoding();
        String currentArtifactInfo = IOUtils.toString((InputStream)inputStream, (String)contentEncoding);
        if (StringUtils.isNotBlank((String)this.currentArtifactInfoPattern) && (matcher = (pattern = Pattern.compile(this.currentArtifactInfoPattern)).matcher(currentArtifactInfo)).find()) {
            currentArtifactInfo = matcher.group(Math.min(matcher.groupCount(), 1));
        }
        return currentArtifactInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private MavenMetadataVersions getArtifactMetadata() {
        InputStream input = null;
        URL url = new URL(this.getArtifactUrlForPath("maven-metadata.xml"));
        LOGGER.finest("Requesting metadata from URL: " + url.toExternalForm());
        URLConnection conn = this.prepareConnection(url);
        input = conn.getInputStream();
        Thread currentThread = Thread.currentThread();
        ClassLoader originalContext = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(MavenMetadataParameterDefinition.class.getClassLoader());
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{MavenMetadataVersions.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        MavenMetadataVersions metadata = (MavenMetadataVersions)unmarshaller.unmarshal(input);
        if (this.sortOrder == SortOrder.DESC) {
            Collections.reverse(metadata.versioning.versions);
        }
        metadata.versioning.versions = this.filterVersions(metadata.versioning.versions);
        MavenMetadataVersions mavenMetadataVersions = metadata;
        currentThread.setContextClassLoader(originalContext);
        IOUtils.closeQuietly((InputStream)input);
        return mavenMetadataVersions;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        currentThread.setContextClassLoader(originalContext);
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Could not parse maven-metadata.xml", e);
                        MavenMetadataVersions result = new MavenMetadataVersions();
                        result.versioning.versions.add("<" + e.getClass().getName() + ": " + e.getMessage() + ">");
                        MavenMetadataVersions mavenMetadataVersions2 = result;
                        IOUtils.closeQuietly((InputStream)input);
                        return mavenMetadataVersions2;
                    }
                }
                catch (Throwable throwable2) {
                    IOUtils.closeQuietly(input);
                    throw throwable2;
                }
            }
        }
    }

    private List<String> filterVersions(List<String> all) {
        ArrayList<String> filteredList = new ArrayList<String>(all.size());
        for (String version : all) {
            if (!this.getVersionFilterPattern().matcher(version).matches()) continue;
            filteredList.add(version);
            if (filteredList.size() != this.getMaxVers()) continue;
            break;
        }
        return filteredList;
    }

    private String getArtifactUrlForPath(String path) {
        StringBuilder versionBuilder = new StringBuilder(this.getRepoBaseUrl());
        versionBuilder.append("/").append(this.getGroupId().replaceAll("\\.", "/"));
        versionBuilder.append("/").append(this.getArtifactId());
        versionBuilder.append("/").append(path);
        return versionBuilder.toString();
    }

    private String getFullArtifactUrl(MavenMetadataParameterValue value) {
        return this.getFullArtifactUrl(value.getGroupId(), value.getArtifactId(), value.getVersion(), value.getPackaging(), value.getClassifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resolveSnapshotRevision(String version) {
        InputStream input = null;
        try {
            LOGGER.finest("Resolving SNAPSHOT version if any...");
            URL url = new URL(this.getArtifactUrlForPath(version + "/maven-metadata.xml"));
            LOGGER.finest("Requesting metadata from URL: " + url.toExternalForm());
            URLConnection conn = this.prepareConnection(url);
            input = conn.getInputStream();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{MavenMetadataVersions.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            MavenMetadataVersions metadata = (MavenMetadataVersions)unmarshaller.unmarshal(input);
            if (metadata.versioning.snapshot != null && !StringUtils.isEmpty((String)metadata.versioning.snapshot.timestamp)) {
                String string = version.replaceAll("SNAPSHOT", "") + metadata.versioning.snapshot.timestamp + "-" + metadata.versioning.snapshot.buildNumber;
                return string;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not parse maven-metadata.xml", e);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
        LOGGER.finest("No match found, using default");
        return version;
    }

    private URLConnection prepareConnection(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        if (StringUtils.isNotBlank((String)url.getUserInfo())) {
            LOGGER.finest("Using implicit UserInfo");
            String encodedAuth = new String(Base64.encodeBase64((byte[])url.getUserInfo().getBytes(UTF8)), UTF8);
            conn.addRequestProperty("Authorization", "Basic " + encodedAuth);
        }
        if (StringUtils.isNotBlank((String)this.credentialsId)) {
            LOGGER.finest("Using explicit UserInfo");
            UsernamePasswordCredentials credentials = this.findCredentialsByCredentialsId();
            if (credentials == null) {
                LOGGER.warning("Cannot resolve credentials with ID " + this.credentialsId);
            } else {
                String userpassword = credentials.getUsername() + ":" + credentials.getPassword();
                String encodedAuthorization = new String(Base64.encodeBase64((byte[])userpassword.getBytes(UTF8)), UTF8);
                conn.addRequestProperty("Authorization", "Basic " + encodedAuthorization);
            }
        }
        return conn;
    }

    @Override
    protected UsernamePasswordCredentials findCredentialsByCredentialsId() {
        List credentials = CredentialsProvider.lookupCredentials(UsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{new DomainRequirement()});
        CredentialsMatcher credentialsIdMatcher = CredentialsMatchers.withId((String)this.credentialsId);
        return (UsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)credentials, (CredentialsMatcher)credentialsIdMatcher);
    }

    private String getFullArtifactUrl(String groupId, String artifactId, String version, String packaging, String classifier) {
        String artifactVersion = version;
        if (version.contains("SNAPSHOT")) {
            artifactVersion = this.resolveSnapshotRevision(version);
        }
        StringBuilder versionBuilder = new StringBuilder(this.getArtifactUrlForPath(version));
        versionBuilder.append("/").append(artifactId);
        versionBuilder.append("-").append(artifactVersion);
        if (StringUtils.isNotBlank((String)classifier)) {
            versionBuilder.append("-").append(classifier);
        }
        versionBuilder.append(".").append(packaging);
        return versionBuilder.toString();
    }

    @Override
    public String getRepoBaseUrl() {
        return this.repoBaseUrl;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getVersionFilter() {
        return this.versionFilter;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getMaxVersions() {
        return this.maxVersions;
    }

    public String getCurrentArtifactInfoUrl() {
        return this.currentArtifactInfoUrl;
    }

    public String getCurrentArtifactInfoLabel() {
        return this.currentArtifactInfoLabel;
    }

    public String getCurrentArtifactInfoPattern() {
        return this.currentArtifactInfoPattern;
    }

    @Override
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @Override
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @Extension
    @Symbol(value={"mavenMetadataVersions"})
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public ListBoxModel doFillCredentialsIdItems() {
            List credentials = CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{new DomainRequirement()});
            CredentialsMatcher credentialsTypeMatcher = CredentialsMatchers.instanceOf(UsernamePasswordCredentials.class);
            return new StandardListBoxModel().withEmptySelection().withMatching(credentialsTypeMatcher, (Iterable)credentials);
        }

        public FormValidation doCheckVersionFilter(@QueryParameter String value) {
            return DescriptorImpl.doCheckRegex(value);
        }

        public FormValidation doCheckCurrentArtifactInfoPattern(@QueryParameter String value) {
            return DescriptorImpl.doCheckRegex(value);
        }

        private static FormValidation doCheckRegex(String value) {
            if (StringUtils.isNotBlank((String)value)) {
                try {
                    Pattern.compile(value);
                }
                catch (PatternSyntaxException pse) {
                    FormValidation.error((String)ResourceBundleHolder.get(MavenMetadataParameterDefinition.class).format("NotValidRegex", new Object[0]));
                }
            }
            return FormValidation.ok();
        }

        public SortOrder[] getSortOrders() {
            return SortOrder.values();
        }

        public String getDisplayName() {
            return ResourceBundleHolder.get(MavenMetadataParameterDefinition.class).format("DisplayName", new Object[0]);
        }
    }

    public static enum SortOrder {
        DESC("Descending"),
        ASC("Ascending");

        private String displayName;

        private SortOrder(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

