/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.os.Build;
import android.support.annotation.ColorRes;
import android.widget.ImageView;

public class RTColorUtil {
    public static ColorStateList createColorStateList(Context ctx, @ColorRes int color) {
        int[][] states = new int[][]{{16842910}, {-16842910}, {-16842912}, {16842919}};
        int[] colors = new int[]{ctx.getResources().getColor(color), ctx.getResources().getColor(color), ctx.getResources().getColor(color), ctx.getResources().getColor(color)};
        return new ColorStateList((int[][])states, colors);
    }

    public static void tintIcon(ImageView icon, @ColorRes int colorRes) {
        if (Build.VERSION.SDK_INT >= 21) {
            RTColorUtil.tintIcon21(icon, colorRes);
        } else {
            RTColorUtil.tintIconCompat(icon, colorRes);
        }
    }

    @TargetApi(value=21)
    private static void tintIcon21(ImageView icon, int colorRes) {
        icon.setImageTintList(ColorStateList.valueOf((int)icon.getContext().getResources().getColor(colorRes)));
    }

    private static void tintIconCompat(ImageView icon, @ColorRes int colorRes) {
        icon.setColorFilter(icon.getContext().getResources().getColor(colorRes));
    }
}

