/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.utils;

import android.animation.Animator;
import android.annotation.TargetApi;
import android.os.Build;
import android.view.View;
import android.view.ViewAnimationUtils;

public class RTAnimationUtil {
    public static void revealView(View oldView, View newView) {
        RTAnimationUtil.revealView(oldView, newView, 0, 0);
    }

    public static void revealView(View oldView, View newView, int w, int h) {
        if (Build.VERSION.SDK_INT >= 21) {
            RTAnimationUtil.revealViewAnimated(oldView, newView, w, h);
        } else {
            newView.setVisibility(0);
            oldView.setVisibility(4);
        }
    }

    @TargetApi(value=21)
    private static void revealViewAnimated(View oldView, View newView, int w, int h) {
        int width = w == 0 ? oldView.getWidth() : w;
        int height = h == 0 ? oldView.getHeight() : h;
        float maxRadius = (float)Math.sqrt(width * width / 4 + height * height / 4);
        Animator reveal = ViewAnimationUtils.createCircularReveal((View)newView, (int)(width / 2), (int)(height / 2), (float)0.0f, (float)maxRadius);
        newView.setVisibility(0);
        oldView.setVisibility(4);
        reveal.start();
    }
}

