/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.location;

import android.content.Context;
import android.location.Location;
import android.location.LocationManager;
import android.support.annotation.NonNull;
import com.google.android.gms.common.GoogleApiAvailability;

public class RTLocation {
    private static final double PK = 57.295780490442965;
    private static final double EARTH_RADIUS = 6371.0;

    public static double findDistance(double lat1, double lon1, double lat2, double lon2) {
        return Math.acos(Math.sin(Math.toRadians(lat1)) * Math.sin(Math.toRadians(lat2)) + Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2)) * (Math.cos(Math.toRadians(lon1)) * Math.cos(Math.toRadians(lon2)) + Math.sin(Math.toRadians(lon1)) * Math.sin(Math.toRadians(lon2)))) * 6371.0;
    }

    public static float findDistance(@NonNull Location fromLocation, @NonNull Location toLocation) {
        return Math.abs(fromLocation.distanceTo(toLocation));
    }

    public static boolean isLocationEnabled(Context ctx) {
        LocationManager lm = null;
        boolean gps_enabled = false;
        boolean network_enabled = false;
        if (lm == null) {
            lm = (LocationManager)ctx.getSystemService("location");
        }
        try {
            gps_enabled = lm.isProviderEnabled("gps");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            network_enabled = lm.isProviderEnabled("network");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return gps_enabled || network_enabled;
    }

    public static boolean areGoogleServicesPresent(Context ctx) {
        try {
            return GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(ctx) == 0;
        }
        catch (Throwable err) {
            return false;
        }
    }
}

