/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.fonts;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.support.v4.util.LruCache;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;

public class RTFontsHelper {
    private static final int WIDTH_PX = 200;
    private static final int HEIGHT_PX = 80;
    private static final LruCache<String, Typeface> sFontsCache = new LruCache(8);
    private static final Map<String, Boolean> supportMap = new HashMap<String, Boolean>();

    protected RTFontsHelper() {
    }

    public static Typeface getTypeface(Context context, String name) {
        Typeface typeface = (Typeface)sFontsCache.get((Object)name);
        if (typeface == null) {
            typeface = Typeface.createFromAsset((AssetManager)context.getResources().getAssets(), (String)name);
            if (typeface == null) {
                Log.e((String)"RTFontsHelper", (String)("Cant init typeface: " + name));
                return null;
            }
            sFontsCache.put((Object)name, (Object)typeface);
        }
        return typeface;
    }

    public static boolean isSupported(Context cxt, String text) {
        if (!supportMap.containsKey(text)) {
            int w = 200;
            int h = 80;
            Resources resources = cxt.getResources();
            float scale = resources.getDisplayMetrics().density;
            Bitmap.Config conf = Bitmap.Config.ARGB_8888;
            Bitmap bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)conf);
            Bitmap orig = bitmap.copy(conf, false);
            Canvas canvas = new Canvas(bitmap);
            Paint paint = new Paint(1);
            paint.setColor(Color.rgb((int)0, (int)0, (int)0));
            paint.setTextSize((float)((int)(14.0f * scale)));
            Rect bounds = new Rect();
            paint.getTextBounds(text, 0, text.length(), bounds);
            int x = (bitmap.getWidth() - bounds.width()) / 2;
            int y = (bitmap.getHeight() + bounds.height()) / 2;
            canvas.drawText(text, (float)x, (float)y, paint);
            supportMap.put(text, !orig.sameAs(bitmap));
            orig.recycle();
            bitmap.recycle();
        }
        return supportMap.get(text);
    }
}

