/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.design;

import android.annotation.TargetApi;
import android.app.Activity;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.widget.ImageButton;

public class RTMaterialUtil {
    @TargetApi(value=21)
    public static void setNavigationBarColorRes(Activity activity, @ColorRes int color) {
        RTMaterialUtil.setNavigationBarColor(activity, activity.getResources().getColor(color));
    }

    @TargetApi(value=21)
    public static void setNavigationBarColor(Activity activity, @ColorInt int color) {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setNavigationBarColor(color);
        }
    }

    @TargetApi(value=21)
    public static void setSystemStatusBarColorRes(Activity activity, @ColorRes int color) {
        RTMaterialUtil.setSystemStatusBarColor(activity, activity.getResources().getColor(color));
    }

    @TargetApi(value=21)
    public static void setSystemStatusBarColor(Activity activity, @ColorInt int color) {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(color);
        }
    }

    public static void colorizeToolbarActions(Toolbar toolbar, @ColorRes int tintColorRes) {
        int menuSize = toolbar.getMenu().size();
        for (int i = 0; i < menuSize; ++i) {
            MenuItem item = toolbar.getMenu().getItem(i);
            Drawable drawable = item.getIcon();
            if (drawable == null) continue;
            drawable = DrawableCompat.wrap((Drawable)drawable);
            DrawableCompat.setTint((Drawable)drawable, (int)toolbar.getContext().getResources().getColor(tintColorRes));
            item.setIcon(drawable);
        }
        PorterDuffColorFilter colorFilter = new PorterDuffColorFilter(toolbar.getContext().getResources().getColor(tintColorRes), PorterDuff.Mode.MULTIPLY);
        for (int i = 0; i < toolbar.getChildCount(); ++i) {
            View v = toolbar.getChildAt(i);
            if (!(v instanceof ImageButton)) continue;
            ((ImageButton)v).getDrawable().setColorFilter((ColorFilter)colorFilter);
        }
        toolbar.invalidate();
    }

    public static void setNavigationItem(Toolbar toolbar, @DrawableRes int iconRes, @ColorRes int tintColorRes) {
        Drawable icon = DrawableCompat.wrap((Drawable)toolbar.getContext().getResources().getDrawable(iconRes));
        DrawableCompat.setTint((Drawable)icon, (int)toolbar.getContext().getResources().getColor(tintColorRes));
        toolbar.setNavigationIcon(icon);
    }
}

