/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.utils;

import android.support.annotation.NonNull;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class RTListUtil {
    public static <T> void replace(@NonNull List<? super T> destination, @NonNull List<? extends T> source) {
        if (destination.size() != 0) {
            destination.clear();
        }
        destination.addAll(source);
    }

    public static <T> void addAll(@NonNull List<? super T> destination, @NonNull List<? extends T> source) {
        destination.addAll(source);
    }

    public static <T> void addUnique(@NonNull List<? super T> destination, @NonNull List<? extends T> source) {
        for (int i = 0; i < source.size(); ++i) {
            if (destination.contains(source.get(i))) continue;
            destination.add(source.get(i));
        }
    }

    public static <T> boolean contains(@NonNull List<? super T> list, @NonNull T element) {
        if (RTListUtil.isEmpty(list)) {
            return false;
        }
        return list.contains(element);
    }

    public static <T> boolean isEmpty(List<T> list) {
        return list == null || list.isEmpty();
    }

    public static <T> boolean contains(@NonNull T[] array, @NonNull T element) {
        for (T item : array) {
            if (item == null || !item.equals(element)) continue;
            return true;
        }
        return false;
    }

    public static <T> int indexOf(@NonNull T[] array, @NonNull T element) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(element)) continue;
            return i;
        }
        return -1;
    }

    public static <T> boolean isNotLast(@NonNull List<T> list, @NonNull T element) {
        return list.indexOf(element) < list.size() - 1;
    }

    public static <T> boolean isSafePosittion(List<T> list, int position) {
        return !RTListUtil.isEmpty(list) && RTListUtil.isSafePosition(list.size(), position);
    }

    public static boolean isSafePosition(int totalCount, int position) {
        return position >= 0 && position < totalCount;
    }

    public static <T> T getLast(@NonNull List<T> list) {
        return RTListUtil.isEmpty(list) ? null : (T)list.get(list.size() - 1);
    }

    public static <T extends Comparable> void sort(@NonNull List<T> list) {
        if (RTListUtil.isEmpty(list)) {
            return;
        }
        Collections.sort(list);
    }

    public static <T extends Comparable> void sort(@NonNull List<T> list, Comparator<? super T> comparator) {
        if (RTListUtil.isEmpty(list) || comparator == null) {
            return;
        }
        Collections.sort(list, comparator);
    }
}

