/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.app;

import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.widget.Toast;

public class RTApp
extends Application {
    private static RTApp instance;
    private Boolean debuggableStatus;

    public static RTApp getInstance() {
        return instance;
    }

    public static RTApp getContext() {
        return instance;
    }

    public static void showToast(@NonNull CharSequence text, boolean longToast) {
        if (instance != null) {
            Toast.makeText((Context)instance, (CharSequence)text, (int)(longToast ? 1 : 0)).show();
        }
    }

    public static void showToast(@StringRes int textId, boolean longToast) {
        if (instance != null) {
            Toast.makeText((Context)instance, (int)textId, (int)(longToast ? 1 : 0)).show();
        }
    }

    public static synchronized boolean isDebuggable() {
        if (RTApp.instance.debuggableStatus == null) {
            try {
                PackageManager pm = instance.getPackageManager();
                ApplicationInfo ai = pm.getApplicationInfo(instance.getPackageName(), 128);
                RTApp.instance.debuggableStatus = ai == null || (ai.flags &= 2) != 0;
            }
            catch (Throwable err) {
                RTApp.instance.debuggableStatus = false;
            }
        }
        return RTApp.instance.debuggableStatus;
    }

    public void onCreate() {
        super.onCreate();
        instance = this;
    }

    public void onTerminate() {
        instance = null;
        super.onTerminate();
    }
}

