/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.ui;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.widget.FrameLayout;

public class RTPinchToZoomFrameLayout
extends FrameLayout {
    private View scaleHud;
    private ScaleGestureDetector mScaleDetector;
    private float scaleFactor = 1.0f;
    private float newScaleFactorToApply = 0.0f;
    private float minScaleFactor = 0.1f;
    private float maxScaleFactor = 2.0f;
    private boolean persistentScaleFactor = false;
    private ScaleHudEventListener scaleHudEventListener;
    private ScaleEventListener scaleEventListener;

    public RTPinchToZoomFrameLayout(Context context) {
        super(context);
    }

    public RTPinchToZoomFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public RTPinchToZoomFrameLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public RTPinchToZoomFrameLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public ScaleHudEventListener getScaleHudEventListener() {
        return this.scaleHudEventListener;
    }

    public void setScaleHudEventListener(ScaleHudEventListener scaleHudEventListener) {
        this.scaleHudEventListener = scaleHudEventListener;
    }

    public ScaleEventListener getScaleEventListener() {
        return this.scaleEventListener;
    }

    public void setScaleEventListener(ScaleEventListener scaleEventListener) {
        this.scaleEventListener = scaleEventListener;
    }

    public boolean isPersistentScaleFactor() {
        return this.persistentScaleFactor;
    }

    public void setPersistentScaleFactor(boolean persistentScaleFactor) {
        this.persistentScaleFactor = persistentScaleFactor;
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(float scaleFactor) {
        if (!(scaleFactor >= this.minScaleFactor) || !(scaleFactor <= this.maxScaleFactor)) {
            throw new IllegalArgumentException(String.format("Scale factor %s is out of its min - max bounds: %s - %s", Float.valueOf(scaleFactor), Float.valueOf(this.minScaleFactor), Float.valueOf(this.maxScaleFactor)));
        }
        this.scaleFactor = scaleFactor;
    }

    public float getMinScaleFactor() {
        return this.minScaleFactor;
    }

    public void setMinScaleFactor(float minScaleFactor) {
        if (!(minScaleFactor > 0.0f) || !(minScaleFactor < this.maxScaleFactor)) {
            throw new IllegalArgumentException(String.format("Min scale factor must be greater than zero and less then max scale factor %s. You specified %s", Float.valueOf(this.maxScaleFactor), Float.valueOf(minScaleFactor)));
        }
        this.minScaleFactor = minScaleFactor;
    }

    public float getMaxScaleFactor() {
        return this.maxScaleFactor;
    }

    public void setMaxScaleFactor(float maxScaleFactor) {
        if (!(maxScaleFactor > this.minScaleFactor)) {
            throw new IllegalArgumentException(String.format("Max scale factor must be greater than min scale factor %s. You specified %s", Float.valueOf(this.minScaleFactor), Float.valueOf(maxScaleFactor)));
        }
        this.maxScaleFactor = maxScaleFactor;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.getChildCount() != 2) {
            throw new IllegalArgumentException("RTPinchToZoomFrameLayout must contain excatly 2 children: first one is the main content, second one is the hud view. Your child count is " + this.getChildCount());
        }
        this.scaleHud = this.getChildAt(1);
        this.mScaleDetector = new ScaleGestureDetector(this.getContext(), (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.scaleHud.getVisibility() == 0 && (event.getAction() == 1 || event.getAction() == 4 || event.getAction() == 3)) {
            this.hideScaleHUD();
        }
        this.mScaleDetector.onTouchEvent(event);
        if (this.scaleHud.getVisibility() == 0 && event.getAction() == 2) {
            return true;
        }
        return super.onTouchEvent(event);
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        return event.getAction() == 2 && event.getPointerCount() == 2;
    }

    private void displayScaleHUD() {
        this.newScaleFactorToApply = this.scaleFactor;
        this.scaleHud.setVisibility(0);
        if (this.scaleHudEventListener != null) {
            this.scaleHudEventListener.onHudShown(this);
        }
    }

    private void updateScaleHUD(float previousScaleFactorToApply) {
        if (this.newScaleFactorToApply == 0.0f) {
            this.newScaleFactorToApply = this.scaleFactor;
        }
        if (this.scaleHudEventListener != null) {
            this.scaleHudEventListener.onScaleChanging(this, this.scaleFactor, previousScaleFactorToApply, this.newScaleFactorToApply);
        }
    }

    private void hideScaleHUD() {
        this.scaleHud.setVisibility(4);
        float oldScaleFactor = this.scaleFactor;
        if (this.newScaleFactorToApply != 0.0f) {
            this.scaleFactor = this.newScaleFactorToApply;
            this.newScaleFactorToApply = 0.0f;
        }
        if (this.scaleHudEventListener != null) {
            this.scaleHudEventListener.onHudHidden(this);
        }
        if (oldScaleFactor != this.scaleFactor && this.scaleEventListener != null) {
            this.scaleEventListener.onScaleChanged(oldScaleFactor, this.scaleFactor);
        }
    }

    public static interface ScaleEventListener {
        public void onScaleChanged(float var1, float var2);
    }

    public static interface ScaleHudEventListener {
        public void onHudShown(RTPinchToZoomFrameLayout var1);

        public void onHudHidden(RTPinchToZoomFrameLayout var1);

        public void onScaleChanging(RTPinchToZoomFrameLayout var1, float var2, float var3, float var4);
    }

    private class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        private ScaleListener() {
        }

        public boolean onScale(ScaleGestureDetector detector) {
            if (RTPinchToZoomFrameLayout.this.scaleHud.getVisibility() != 0) {
                RTPinchToZoomFrameLayout.this.displayScaleHUD();
                if (!RTPinchToZoomFrameLayout.this.persistentScaleFactor) {
                    RTPinchToZoomFrameLayout.this.scaleFactor = RTPinchToZoomFrameLayout.this.minScaleFactor + (RTPinchToZoomFrameLayout.this.maxScaleFactor - RTPinchToZoomFrameLayout.this.minScaleFactor) / 2.0f;
                }
            }
            if (RTPinchToZoomFrameLayout.this.newScaleFactorToApply == 0.0f) {
                RTPinchToZoomFrameLayout.this.newScaleFactorToApply = RTPinchToZoomFrameLayout.this.scaleFactor;
            }
            float prevScaleFactorToApply = RTPinchToZoomFrameLayout.this.newScaleFactorToApply;
            RTPinchToZoomFrameLayout.this.newScaleFactorToApply *= detector.getScaleFactor();
            if (RTPinchToZoomFrameLayout.this.newScaleFactorToApply < RTPinchToZoomFrameLayout.this.minScaleFactor) {
                RTPinchToZoomFrameLayout.this.newScaleFactorToApply = RTPinchToZoomFrameLayout.this.minScaleFactor;
            }
            if (RTPinchToZoomFrameLayout.this.newScaleFactorToApply > RTPinchToZoomFrameLayout.this.maxScaleFactor) {
                RTPinchToZoomFrameLayout.this.newScaleFactorToApply = RTPinchToZoomFrameLayout.this.maxScaleFactor;
            }
            RTPinchToZoomFrameLayout.this.updateScaleHUD(prevScaleFactorToApply);
            return true;
        }
    }
}

