/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.graphics;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Paint;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class RTBitmaps {
    private RTBitmaps() {
    }

    public static Bitmap loadBitmapFromUrl(String link, int downscaleSize) throws IOException {
        URL url = new URL(link);
        if (downscaleSize > 0) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.connect();
            InputStream input = connection.getInputStream();
            BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)options);
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.connect();
            input = connection.getInputStream();
            int inSampleSize = RTBitmaps.calculateInSampleSize(options, downscaleSize);
            options = new BitmapFactory.Options();
            options.inSampleSize = inSampleSize;
            return BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)options);
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoInput(true);
        connection.connect();
        InputStream input = connection.getInputStream();
        return BitmapFactory.decodeStream((InputStream)input);
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqSize) {
        int scale = 1;
        if (options.outHeight > reqSize || options.outWidth > reqSize) {
            scale = (int)Math.pow(2.0, (int)Math.round(Math.log((double)reqSize / (double)Math.max(options.outHeight, options.outWidth)) / Math.log(0.5)));
        }
        return scale;
    }

    public static Bitmap loadBitmapFromFile(File file, int reqSize) {
        if (reqSize > 0) {
            try {
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                FileInputStream fis = new FileInputStream(file);
                BitmapFactory.decodeStream((InputStream)fis, null, (BitmapFactory.Options)options);
                fis.close();
                int inSampleSize = RTBitmaps.calculateInSampleSize(options, reqSize);
                options = new BitmapFactory.Options();
                options.inSampleSize = inSampleSize;
                fis = new FileInputStream(file);
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)fis, null, (BitmapFactory.Options)options);
                fis.close();
                return bitmap;
            }
            catch (IOException err) {
                return null;
            }
        }
        return BitmapFactory.decodeFile((String)file.getAbsolutePath());
    }

    public static void saveBitmapToFile(Bitmap bm, int quality, File file) throws IOException {
        if (bm != null) {
            FileOutputStream fos = new FileOutputStream(file);
            bm.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)fos);
            fos.flush();
            fos.close();
        } else {
            file.delete();
        }
    }

    public static Bitmap toGrayscale(Bitmap bmpOriginal) {
        int height = bmpOriginal.getHeight();
        int width = bmpOriginal.getWidth();
        Bitmap bmpGrayscale = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(bmpGrayscale);
        Paint paint = new Paint();
        ColorMatrix cm = new ColorMatrix();
        cm.setSaturation(0.0f);
        ColorMatrixColorFilter f = new ColorMatrixColorFilter(cm);
        paint.setColorFilter((ColorFilter)f);
        c.drawBitmap(bmpOriginal, 0.0f, 0.0f, paint);
        return bmpGrayscale;
    }
}

