/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.app.injector;

import android.app.Activity;
import android.app.Application;
import android.app.Service;
import android.content.ContentProvider;
import android.content.IntentFilter;
import android.util.Pair;
import eu.livotov.labs.android.robotools.app.RTActivity;
import eu.livotov.labs.android.robotools.app.injector.RTInjectorClassMetaData;
import eu.livotov.labs.android.robotools.app.injector.ann.InjectActionBar;
import eu.livotov.labs.android.robotools.app.injector.ann.InjectApp;
import eu.livotov.labs.android.robotools.app.injector.ann.InjectClickEvent;
import eu.livotov.labs.android.robotools.app.injector.ann.InjectExtra;
import eu.livotov.labs.android.robotools.app.injector.ann.InjectFragment;
import eu.livotov.labs.android.robotools.app.injector.ann.InjectLayout;
import eu.livotov.labs.android.robotools.app.injector.ann.InjectOptionMenu;
import eu.livotov.labs.android.robotools.app.injector.ann.InjectReceiver;
import eu.livotov.labs.android.robotools.app.injector.ann.InjectResource;
import eu.livotov.labs.android.robotools.app.injector.ann.InjectServiceConnection;
import eu.livotov.labs.android.robotools.app.injector.ann.InjectSystemService;
import eu.livotov.labs.android.robotools.app.injector.ann.InjectView;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

final class RTInjectorClassMetadataLoader {
    private static final Map<Class, RTInjectorClassMetaData> sCache = new HashMap<Class, RTInjectorClassMetaData>();

    private RTInjectorClassMetadataLoader() {
    }

    public static RTInjectorClassMetaData loadClass(Class clazz) {
        RTInjectorClassMetaData result = sCache.get(clazz);
        if (result == null) {
            MetaData data = new MetaData();
            RTInjectorClassMetadataLoader.loadClassMetaData(clazz, data);
            result = data.toClassMetaData();
            sCache.put(clazz, result);
        }
        return result;
    }

    static void loadClassMetaData(Class clazz, MetaData data) {
        InjectLayout classAnnotation = clazz.getAnnotation(InjectLayout.class);
        if (classAnnotation instanceof InjectLayout) {
            if (data.injects == null) {
                data.injects = new Stack();
            }
            data.injects.add(new InjectLayout.MetaData(classAnnotation));
        }
        for (Method method : clazz.getDeclaredMethods()) {
            InjectClickEvent annotation;
            method.setAccessible(true);
            if (Modifier.isStatic(method.getModifiers()) || (annotation = method.getAnnotation(InjectClickEvent.class)) == null) continue;
            if (data.clickers == null) {
                data.clickers = new HashMap<Integer, Method>();
            }
            for (int id2 : annotation.value()) {
                data.clickers.put(id2, method);
            }
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
            Annotation[] annotations;
            ((Field)accessibleObject).setAccessible(true);
            int modifiers = ((Field)accessibleObject).getModifiers();
            if (Modifier.isStatic(modifiers) || (annotations = accessibleObject.getAnnotations()) == null) continue;
            for (Annotation annotation : annotations) {
                if (annotation instanceof InjectView) {
                    if (data.widgets == null) {
                        data.widgets = new HashMap<Field, InjectView.MetaData>();
                    }
                    data.widgets.put((Field)accessibleObject, new InjectView.MetaData((InjectView)annotation));
                    continue;
                }
                if (annotation instanceof InjectExtra) {
                    if (data.extras == null) {
                        data.extras = new HashMap<Field, InjectExtra.MetaData>();
                    }
                    data.extras.put((Field)accessibleObject, new InjectExtra.MetaData((InjectExtra)annotation, (Field)accessibleObject));
                    continue;
                }
                if (annotation instanceof InjectFragment) {
                    if (data.fragments == null) {
                        data.fragments = new HashMap<Field, Integer>();
                    }
                    data.fragments.put((Field)accessibleObject, ((InjectFragment)annotation).value());
                    continue;
                }
                if (annotation instanceof InjectResource) {
                    if (data.resources == null) {
                        data.resources = new HashMap<Field, InjectResource.MetaData>();
                    }
                    data.resources.put((Field)accessibleObject, new InjectResource.MetaData((InjectResource)annotation, (Field)accessibleObject));
                    continue;
                }
                if (annotation instanceof InjectSystemService) {
                    if (data.systemServices == null) {
                        data.systemServices = new HashMap<Field, String>();
                    }
                    data.systemServices.put((Field)accessibleObject, InjectSystemService.SERVICES_MAP.get(((Field)accessibleObject).getType()));
                    continue;
                }
                if (annotation instanceof InjectReceiver) {
                    if (data.receivers == null) {
                        data.receivers = new HashMap<Field, IntentFilter>();
                    }
                    data.receivers.put((Field)accessibleObject, InjectReceiver.Processor.process((InjectReceiver)annotation));
                    continue;
                }
                if (annotation instanceof InjectServiceConnection) {
                    if (data.serviceConnections == null) {
                        data.serviceConnections = new HashMap<Field, InjectServiceConnection.MetaData>();
                    }
                    data.serviceConnections.put((Field)accessibleObject, new InjectServiceConnection.MetaData((InjectServiceConnection)annotation));
                    continue;
                }
                if (annotation instanceof InjectActionBar) {
                    if (data.actionBars == null) {
                        data.actionBars = new ArrayList<Field>();
                    }
                    data.actionBars.add((Field)accessibleObject);
                    continue;
                }
                if (annotation instanceof InjectApp) {
                    if (data.applications == null) {
                        data.applications = new ArrayList<Field>();
                    }
                    data.applications.add((Field)accessibleObject);
                    continue;
                }
                if (!(annotation instanceof InjectOptionMenu)) continue;
                if (data.menuItems == null) {
                    data.menuItems = new HashMap<Field, Integer>();
                }
                data.menuItems.put((Field)accessibleObject, ((InjectOptionMenu)annotation).value());
            }
        }
        Class superclass = clazz.getSuperclass();
        if (superclass != null && RTInjectorClassMetadataLoader.canMoveToUpperLevel(superclass)) {
            RTInjectorClassMetadataLoader.loadClassMetaData(superclass, data);
        }
    }

    static boolean canMoveToUpperLevel(Class superclass) {
        if (Activity.class.isAssignableFrom(superclass)) {
            return !RTActivity.class.equals((Object)superclass) && !Activity.class.equals((Object)superclass);
        }
        if (InjectFragment.class.isAssignableFrom(superclass)) {
            return !InjectFragment.class.equals((Object)superclass);
        }
        if (Application.class.isAssignableFrom(superclass)) {
            return !Application.class.equals((Object)superclass);
        }
        if (Service.class.isAssignableFrom(superclass)) {
            return !Service.class.equals((Object)superclass);
        }
        if (ContentProvider.class.isAssignableFrom(superclass)) {
            return !ContentProvider.class.equals((Object)superclass);
        }
        return false;
    }

    private static <K, V> Pair<K, V>[] mapToPairArray(Map<K, V> map) {
        Pair[] result = new Pair[map.size()];
        int i = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result[i] = new Pair(entry.getKey(), entry.getValue());
            ++i;
        }
        return result;
    }

    private static <K> RTInjectorClassMetaData.IntPair<K>[] mapToPairIntArray(Map<K, Integer> map) {
        RTInjectorClassMetaData.IntPair[] result = new RTInjectorClassMetaData.IntPair[map.size()];
        int i = 0;
        for (Map.Entry<K, Integer> entry : map.entrySet()) {
            result[i] = new RTInjectorClassMetaData.IntPair<K>(entry.getKey(), entry.getValue());
            ++i;
        }
        return result;
    }

    private static <K, V> List<Pair<K, V>> mapToPairList(Map<K, V> map) {
        ArrayList<Pair<K, V>> result = new ArrayList<Pair<K, V>>(map.size());
        int i = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result.add(i, new Pair(entry.getKey(), entry.getValue()));
            ++i;
        }
        return result;
    }

    private static <K> List<RTInjectorClassMetaData.IntPair<K>> mapToPairIntList(Map<K, Integer> map) {
        ArrayList<RTInjectorClassMetaData.IntPair<K>> result = new ArrayList<RTInjectorClassMetaData.IntPair<K>>(map.size());
        int i = 0;
        for (Map.Entry<K, Integer> entry : map.entrySet()) {
            result.add(i, new RTInjectorClassMetaData.IntPair<K>(entry.getKey(), entry.getValue()));
            ++i;
        }
        return result;
    }

    private static class MetaData {
        Stack<InjectLayout.MetaData> injects;
        List<Field> actionBars;
        List<Field> applications;
        Map<Field, String> systemServices;
        Map<Class, int[]> rootListeners;
        Map<Integer, Method> clickers;
        Map<Field, InjectExtra.MetaData> extras;
        Map<Field, Integer> fragments;
        Map<Field, Integer> menuItems;
        Map<Field, InjectResource.MetaData> resources;
        Map<Field, IntentFilter> receivers;
        Map<Field, InjectServiceConnection.MetaData> serviceConnections;
        Map<Field, InjectView.MetaData> widgets;

        private MetaData() {
        }

        RTInjectorClassMetaData toClassMetaData() {
            RTInjectorClassMetaData result = new RTInjectorClassMetaData();
            if (this.injects != null) {
                while (!this.injects.empty()) {
                    InjectLayout.MetaData data = this.injects.pop();
                    if (data.layout != 0) {
                        result.layout = data.layout;
                    }
                    if (data.menu != 0) {
                        result.menu = data.menu;
                    }
                    if (data.title == 0) continue;
                    result.title = data.title;
                }
            }
            result.rootIds = this.rootListeners;
            result.clickers = this.clickers;
            if (this.actionBars != null) {
                result.actionBars = this.actionBars;
            }
            if (this.applications != null) {
                result.applications = this.applications;
            }
            if (this.systemServices != null) {
                result.systemServices = RTInjectorClassMetadataLoader.mapToPairList(this.systemServices);
            }
            if (this.extras != null) {
                result.extras = RTInjectorClassMetadataLoader.mapToPairList(this.extras);
            }
            if (this.fragments != null) {
                result.fragments = RTInjectorClassMetadataLoader.mapToPairIntList(this.fragments);
            }
            if (this.menuItems != null) {
                result.menuItems = RTInjectorClassMetadataLoader.mapToPairIntList(this.menuItems);
            }
            if (this.resources != null) {
                result.resources = RTInjectorClassMetadataLoader.mapToPairList(this.resources);
            }
            if (this.receivers != null) {
                result.receivers = RTInjectorClassMetadataLoader.mapToPairList(this.receivers);
            }
            if (this.serviceConnections != null) {
                result.serviceConnections = RTInjectorClassMetadataLoader.mapToPairList(this.serviceConnections);
            }
            if (this.widgets != null) {
                result.widgets = RTInjectorClassMetadataLoader.mapToPairList(this.widgets);
            }
            return result;
        }
    }
}

