/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.app.design.dialog;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import android.widget.Toast;
import eu.livotov.labs.android.robotools.R;
import eu.livotov.labs.android.robotools.app.design.bottomsheet.RTBottomSheet;
import eu.livotov.labs.android.robotools.os.RTKeyboard;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class RTDialog {
    public static void showOptionsDialog(Activity ctx, String title, String[] options, int defaultOption, RTOptionsDialogResultListener listener) {
        RTDialog.showOptionsDialog(ctx, 0, title, Arrays.asList(options), defaultOption, listener);
    }

    public static void showOptionsDialog(Activity ctx, int iconRes, String title, String[] options, int defaultOption, RTOptionsDialogResultListener listener) {
        RTDialog.showOptionsDialog(ctx, iconRes, title, Arrays.asList(options), defaultOption, listener);
    }

    public static void showOptionsDialog(Activity ctx, int titleRes, int[] optionsRes, int defaultOption, RTOptionsDialogResultListener listener) {
        RTDialog.showOptionsDialog(ctx, 0, titleRes, optionsRes, defaultOption, listener);
    }

    public static void showOptionsDialog(Activity ctx, int iconRes, int titleRes, int[] optionsRes, int defaultOption, RTOptionsDialogResultListener listener) {
        ArrayList<String> optionsStrings = new ArrayList<String>();
        for (int optionRes : optionsRes) {
            optionsStrings.add(ctx.getString(optionRes));
        }
        RTDialog.showOptionsDialog(ctx, iconRes, ctx.getString(titleRes), optionsStrings, defaultOption, listener);
    }

    public static void showOptionsDialog(Activity ctx, String title, Collection options, int defaultOption, RTOptionsDialogResultListener r) {
        RTDialog.showOptionsDialog(ctx, 0, title, options, defaultOption, r);
    }

    public static void showOptionsDialog(Activity ctx, int iconRes, String title, Collection options, int defaultOption, final RTOptionsDialogResultListener r) {
        RTBottomSheet.Builder builder = new RTBottomSheet.Builder(ctx);
        int index = 0;
        for (Object option : options) {
            builder.sheet(index, option.toString());
            ++index;
        }
        builder.title(title);
        builder.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (r != null) {
                    r.selectionCancelled();
                }
            }
        });
        builder.listener(new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (r != null) {
                    r.optionSelected(which);
                }
            }
        });
        builder.build().show();
    }

    public static void showMessageBox(Activity ctx, int iconRes, int titleRes, int messageRes, RTModalDialogResultListener listener) {
        RTDialog.showMessageBox(ctx, iconRes, ctx.getString(titleRes), ctx.getString(messageRes), listener);
    }

    public static void showMessageBox(Activity ctx, int iconRes, String title, String msg, final RTModalDialogResultListener listener) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)ctx);
        builder.setTitle((CharSequence)title);
        builder.setIcon(iconRes);
        builder.setMessage((CharSequence)msg);
        if (listener != null) {
            builder.setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                    listener.onDialogClosed();
                    dialogInterface.dismiss();
                }
            });
        } else {
            builder.setPositiveButton((CharSequence)"OK", null);
        }
        builder.show();
    }

    public static void showYesNoDialog(Activity ctx, int icon, int messageRes, RTYesNoDialogResultListener listener) {
        RTDialog.showYesNoDialog(ctx, icon, ctx.getString(messageRes), listener);
    }

    @Deprecated
    public static void showYesNoDialog(Activity ctx, int icon, int titleRes, int messageRes, RTYesNoDialogResultListener listener) {
        RTDialog.showYesNoDialog(ctx, icon, ctx.getString(messageRes), listener);
    }

    @Deprecated
    public static void showYesNoDialog(Activity ctx, int icon, String title, String message, RTYesNoDialogResultListener listener) {
        RTDialog.showYesNoDialog(ctx, icon, message, listener);
    }

    public static void showYesNoDialog(Activity ctx, int icon, String message, final RTYesNoDialogResultListener listener) {
        RTBottomSheet.Builder builder = new RTBottomSheet.Builder(ctx);
        builder.icon(icon).title(message);
        builder.sheet(1, ctx.getString(R.string.robotools_dialogbtn_yes));
        builder.sheet(2, ctx.getString(R.string.robotools_dialogbtn_no));
        builder.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (listener != null) {
                    listener.onNo();
                }
            }
        });
        builder.listener(new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (listener != null) {
                    switch (which) {
                        case 1: {
                            listener.onYes();
                            break;
                        }
                        case 2: {
                            listener.onNo();
                            break;
                        }
                        default: {
                            listener.onNo();
                        }
                    }
                }
            }
        });
        builder.build().show();
    }

    public static RTInputDialogBuilder buildInputDialog(Activity ctx) {
        return new RTInputDialogBuilder((Context)ctx);
    }

    public static void showNotification(Context ctx, String message) {
        RTDialog.showNotification(ctx, message, 0);
    }

    public static void showNotification(Context ctx, int message) {
        RTDialog.showNotification(ctx, ctx.getString(message));
    }

    public static void showNotification(Context ctx, String message, int length) {
        Toast.makeText((Context)ctx, (CharSequence)message, (int)length).show();
    }

    public static void showNotification(Context ctx, int message, int length) {
        RTDialog.showNotification(ctx, ctx.getString(message), length);
    }

    public static class RTInputDialogBuilder {
        private Context ctx;
        private String title;
        private String message;
        private String hint;
        private String defaultValue;
        private Drawable icon;
        private String positiveButton = "OK";
        private String negativeButton;
        private boolean cancellable = true;

        public RTInputDialogBuilder(Context ctx) {
            this.ctx = ctx;
        }

        public RTInputDialogBuilder title(String title) {
            this.title = title;
            return this;
        }

        public RTInputDialogBuilder title(int titleRes) {
            this.title = this.ctx.getString(titleRes);
            return this;
        }

        public RTInputDialogBuilder message(String message) {
            this.message = message;
            return this;
        }

        public RTInputDialogBuilder message(int messageRes) {
            this.message = this.ctx.getString(messageRes);
            return this;
        }

        public RTInputDialogBuilder hint(String hint) {
            this.hint = hint;
            return this;
        }

        public RTInputDialogBuilder hint(int hintRes) {
            this.hint = this.ctx.getString(hintRes);
            return this;
        }

        public RTInputDialogBuilder value(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public RTInputDialogBuilder value(int defaultValueRes) {
            this.defaultValue = this.ctx.getString(defaultValueRes);
            return this;
        }

        public RTInputDialogBuilder positiveButton(String txt) {
            this.positiveButton = txt;
            return this;
        }

        public RTInputDialogBuilder positiveButton(int txtRes) {
            this.positiveButton = this.ctx.getString(txtRes);
            return this;
        }

        public RTInputDialogBuilder negativeButton(String txt) {
            this.negativeButton = txt;
            return this;
        }

        public RTInputDialogBuilder negativeButton(int txtRes) {
            this.negativeButton = this.ctx.getString(txtRes);
            return this;
        }

        public RTInputDialogBuilder icon(int iconRes) {
            this.icon = this.ctx.getResources().getDrawable(iconRes);
            return this;
        }

        public RTInputDialogBuilder nega(Drawable icon) {
            this.icon = icon;
            return this;
        }

        public RTInputDialogBuilder cancellable(boolean c) {
            this.cancellable = c;
            return this;
        }

        public void build(final RTInputDialogResultListener listener) {
            AlertDialog.Builder alert = new AlertDialog.Builder(this.ctx);
            if (!TextUtils.isEmpty((CharSequence)this.title)) {
                alert.setTitle((CharSequence)this.title);
            }
            if (!TextUtils.isEmpty((CharSequence)this.message)) {
                alert.setMessage((CharSequence)this.message);
            }
            final EditText input = new EditText(this.ctx);
            input.setSingleLine(true);
            if (!TextUtils.isEmpty((CharSequence)this.defaultValue)) {
                input.setText((CharSequence)this.defaultValue);
                input.setSelection(0, input.getText().length());
            }
            alert.setView((View)input);
            alert.setCancelable(true);
            alert.setPositiveButton((CharSequence)this.positiveButton, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int whichButton) {
                    if (listener != null) {
                        listener.onInputConfirmed(input.getText().toString());
                    }
                    dialog.dismiss();
                }
            });
            if (!TextUtils.isEmpty((CharSequence)this.negativeButton)) {
                alert.setNegativeButton((CharSequence)this.negativeButton, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        if (listener != null) {
                            listener.onInputCancelled();
                        }
                        dialog.dismiss();
                    }
                });
            }
            alert.setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialogInterface) {
                    if (listener != null) {
                        listener.onInputCancelled();
                    }
                    dialogInterface.dismiss();
                }
            });
            alert.show();
            RTKeyboard.showSoftKeyboardFor(this.ctx, (View)input);
        }
    }

    public static interface RTOptionsDialogResultListener {
        public void optionSelected(int var1);

        public void selectionCancelled();
    }

    public static interface RTInputDialogResultListener {
        public void onInputConfirmed(String var1);

        public void onInputCancelled();
    }

    public static interface RTYesNoDialogResultListener {
        public void onYes();

        public void onNo();
    }

    public static interface RTModalDialogResultListener {
        public void onDialogClosed();
    }
}

