/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.app.design.bottomsheet.model;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.ActionProvider;
import android.view.ContextMenu;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;

public class BottomSheetActionMenuItem
implements MenuItem {
    private static final int NO_ICON = 0;
    private static final int CHECKABLE = 1;
    private static final int CHECKED = 2;
    private static final int EXCLUSIVE = 4;
    private static final int HIDDEN = 8;
    private static final int ENABLED = 16;
    private final int mId;
    private final int mGroup;
    private final int mCategoryOrder;
    private final int mOrdering;
    private CharSequence mTitle;
    private CharSequence mTitleCondensed;
    private Intent mIntent;
    private char mShortcutNumericChar;
    private char mShortcutAlphabeticChar;
    private Drawable mIconDrawable;
    private int mIconResId = 0;
    private Context mContext;
    private MenuItem.OnMenuItemClickListener mClickListener;
    private int mFlags = 16;

    public BottomSheetActionMenuItem(Context context, int group, int id, int categoryOrder, int ordering, CharSequence title) {
        this.mContext = context;
        this.mId = id;
        this.mGroup = group;
        this.mCategoryOrder = categoryOrder;
        this.mOrdering = ordering;
        this.mTitle = title;
    }

    public int getItemId() {
        return this.mId;
    }

    public int getGroupId() {
        return this.mGroup;
    }

    public int getOrder() {
        return this.mOrdering;
    }

    public MenuItem setTitle(CharSequence title) {
        this.mTitle = title;
        return this;
    }

    public MenuItem setTitle(int title) {
        this.mTitle = this.mContext.getResources().getString(title);
        return this;
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public MenuItem setTitleCondensed(CharSequence title) {
        this.mTitleCondensed = title;
        return this;
    }

    public CharSequence getTitleCondensed() {
        return this.mTitleCondensed != null ? this.mTitleCondensed : this.mTitle;
    }

    public MenuItem setIcon(Drawable icon) {
        this.mIconDrawable = icon;
        this.mIconResId = 0;
        return this;
    }

    @TargetApi(value=21)
    public MenuItem setIcon(int iconRes) {
        this.mIconResId = iconRes;
        if (iconRes > 0) {
            this.mIconDrawable = Build.VERSION.SDK_INT >= 21 ? this.mContext.getResources().getDrawable(iconRes, null) : this.mContext.getResources().getDrawable(iconRes);
        }
        return this;
    }

    public Drawable getIcon() {
        return this.mIconDrawable;
    }

    public MenuItem setIntent(Intent intent) {
        this.mIntent = intent;
        return this;
    }

    public Intent getIntent() {
        return this.mIntent;
    }

    public MenuItem setShortcut(char numericChar, char alphaChar) {
        this.mShortcutNumericChar = numericChar;
        this.mShortcutAlphabeticChar = alphaChar;
        return this;
    }

    public MenuItem setNumericShortcut(char numericChar) {
        this.mShortcutNumericChar = numericChar;
        return this;
    }

    public char getNumericShortcut() {
        return this.mShortcutNumericChar;
    }

    public MenuItem setAlphabeticShortcut(char alphaChar) {
        this.mShortcutAlphabeticChar = alphaChar;
        return this;
    }

    public char getAlphabeticShortcut() {
        return this.mShortcutAlphabeticChar;
    }

    public MenuItem setCheckable(boolean checkable) {
        this.mFlags = this.mFlags & 0xFFFFFFFE | (checkable ? 1 : 0);
        return this;
    }

    public boolean isCheckable() {
        return (this.mFlags & 1) != 0;
    }

    public MenuItem setChecked(boolean checked) {
        this.mFlags = this.mFlags & 0xFFFFFFFD | (checked ? 2 : 0);
        return this;
    }

    public boolean isChecked() {
        return (this.mFlags & 2) != 0;
    }

    public MenuItem setVisible(boolean visible) {
        this.mFlags = this.mFlags & 8 | (visible ? 0 : 8);
        return this;
    }

    public boolean isVisible() {
        return (this.mFlags & 8) == 0;
    }

    public MenuItem setEnabled(boolean enabled) {
        this.mFlags = this.mFlags & 0xFFFFFFEF | (enabled ? 16 : 0);
        return this;
    }

    public boolean isEnabled() {
        return (this.mFlags & 0x10) != 0;
    }

    public boolean hasSubMenu() {
        return false;
    }

    public SubMenu getSubMenu() {
        return null;
    }

    public MenuItem setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener menuItemClickListener) {
        this.mClickListener = menuItemClickListener;
        return this;
    }

    public ContextMenu.ContextMenuInfo getMenuInfo() {
        return null;
    }

    public void setShowAsAction(int show) {
    }

    public MenuItem setShowAsActionFlags(int actionEnum) {
        this.setShowAsAction(actionEnum);
        return this;
    }

    public MenuItem setActionView(View actionView) {
        throw new UnsupportedOperationException();
    }

    public MenuItem setActionView(int resId) {
        throw new UnsupportedOperationException();
    }

    public View getActionView() {
        return null;
    }

    public MenuItem setActionProvider(ActionProvider actionProvider) {
        throw new UnsupportedOperationException();
    }

    public ActionProvider getActionProvider() {
        throw new UnsupportedOperationException();
    }

    public boolean expandActionView() {
        return false;
    }

    public boolean collapseActionView() {
        return false;
    }

    public boolean isActionViewExpanded() {
        return false;
    }

    public MenuItem setOnActionExpandListener(MenuItem.OnActionExpandListener listener) {
        throw new UnsupportedOperationException();
    }

    public BottomSheetActionMenuItem setExclusiveCheckable(boolean exclusive) {
        this.mFlags = this.mFlags & 0xFFFFFFFB | (exclusive ? 4 : 0);
        return this;
    }

    public boolean invoke() {
        if (this.mClickListener != null && this.mClickListener.onMenuItemClick((MenuItem)this)) {
            return true;
        }
        if (this.mIntent != null) {
            this.mContext.startActivity(this.mIntent);
            return true;
        }
        return false;
    }
}

