/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.camview.scanner.util;

import android.content.Context;
import android.media.MediaPlayer;
import android.util.Log;

public class SoundPlayer
implements MediaPlayer.OnPreparedListener {
    private MediaPlayer mPlayer;
    private Context ctx;

    public SoundPlayer(Context ctx) {
        this.ctx = ctx;
        this.initPlayer();
    }

    private synchronized void initPlayer() {
    }

    public void playRawResource(int rawResource, boolean loop) {
        this.stop();
        try {
            this.mPlayer = MediaPlayer.create((Context)this.ctx, (int)rawResource);
            if (loop) {
                this.mPlayer.setLooping(loop);
            }
            this.mPlayer.start();
        }
        catch (Exception ex) {
            Log.e((String)this.getClass().getSimpleName(), (String)("Could not play audio file: " + ex.getMessage()));
            this.mPlayer = null;
        }
    }

    public void stop() {
        if (this.mPlayer != null) {
            try {
                if (this.mPlayer.isPlaying()) {
                    this.mPlayer.stop();
                }
                this.mPlayer.release();
                this.mPlayer = null;
            }
            catch (Throwable err) {
                Log.e((String)this.getClass().getSimpleName(), (String)("EXCEPTION: " + err.getMessage()));
            }
        }
    }

    public void onPrepared(MediaPlayer mp) {
        try {
            mp.start();
        }
        catch (Exception ex) {
            this.stop();
        }
    }
}

