/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.camview.scanner.decoder.zxing;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;
import eu.livotov.labs.android.camview.scanner.decoder.BarcodeDecoder;
import eu.livotov.labs.android.camview.scanner.decoder.zxing.PlanarRotatedYUVLuminanceSource;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;

public class ZXDecoder
implements BarcodeDecoder {
    protected Map<DecodeHintType, Object> hints = new EnumMap<DecodeHintType, Object>(DecodeHintType.class);
    private MultiFormatReader reader = new MultiFormatReader();
    private double scanAreaPercent = 0.7;

    public ZXDecoder() {
        this.hints.put(DecodeHintType.POSSIBLE_FORMATS, EnumSet.allOf(BarcodeFormat.class));
        this.hints.put(DecodeHintType.CHARACTER_SET, "utf-8");
        this.hints.put(DecodeHintType.TRY_HARDER, true);
        this.reader.setHints(this.hints);
    }

    public double getScanAreaPercent() {
        return this.scanAreaPercent;
    }

    @Override
    public void setScanAreaPercent(double scanAreaPercent) {
        if (scanAreaPercent < 0.1 || scanAreaPercent > 1.0) {
            throw new IllegalArgumentException("Scan area percent must be between 0.1 (10%) to 1.0 (100%). Specified value was " + scanAreaPercent);
        }
        this.scanAreaPercent = scanAreaPercent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String decode(byte[] image, int width, int height) {
        BinaryBitmap bitmap;
        Result result = null;
        int scanWidth = (int)((double)width * this.scanAreaPercent);
        int scanHeight = (int)((double)height * this.scanAreaPercent);
        int scanAreaLeft = width / 2 - scanWidth / 2;
        int scanAreaRight = width / 2 + scanWidth / 2;
        int scanAreaTop = height / 2 - scanHeight / 2;
        int scanAreaBottom = height / 2 + scanHeight / 2;
        try {
            bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)new PlanarYUVLuminanceSource(image, width, height, scanAreaLeft, scanAreaTop, scanAreaRight, scanAreaBottom, true)));
            result = this.reader.decodeWithState(bitmap);
            if (result != null) {
                String string = result.getText();
                return string;
            }
        }
        catch (Throwable err) {
        }
        finally {
            this.reader.reset();
        }
        try {
            bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)new PlanarRotatedYUVLuminanceSource(image, width, height, scanAreaLeft, scanAreaTop, scanAreaRight, scanAreaBottom, true)));
            result = this.reader.decodeWithState(bitmap);
            if (result != null) {
                String string = result.getText();
                return string;
            }
        }
        catch (Throwable re) {
        }
        finally {
            this.reader.reset();
        }
        return null;
    }
}

