/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.d3s;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.http.SslError;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.webkit.JavascriptInterface;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import eu.livotov.labs.android.d3s.D3SSViewAuthorizationListener;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class D3SView
extends WebView {
    private static String JavaScriptNS = "D3SJS";
    private static Pattern mdFinder = Pattern.compile(".*?(<input[^<>]* name=\\\"MD\\\"[^<>]*>).*?", 32);
    private static Pattern paresFinder = Pattern.compile(".*?(<input[^<>]* name=\\\"PaRes\\\"[^<>]*>).*?", 32);
    private static Pattern valuePattern = Pattern.compile(".*? value=\\\"(.*?)\\\"", 32);
    private boolean urlReturned = false;
    private boolean debugMode = false;
    private String postbackUrl = "https://www.google.com";
    private boolean postbackHandled = false;
    private D3SSViewAuthorizationListener authorizationListener = null;

    public D3SView(Context context) {
        super(context);
        this.initUI();
    }

    private void initUI() {
        this.getSettings().setJavaScriptEnabled(true);
        this.getSettings().setBuiltInZoomControls(true);
        this.addJavascriptInterface(new D3SJSInterface(), JavaScriptNS);
        this.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (!D3SView.this.postbackHandled && url.toLowerCase().contains(D3SView.this.postbackUrl.toLowerCase())) {
                    D3SView.this.postbackHandled = true;
                    view.loadUrl(String.format("javascript:window.%s.processHTML(document.getElementsByTagName('html')[0].innerHTML);", JavaScriptNS));
                    return true;
                }
                return super.shouldOverrideUrlLoading(view, url);
            }

            public void onPageStarted(WebView view, String url, Bitmap icon) {
                if (!D3SView.this.urlReturned && !D3SView.this.postbackHandled) {
                    if (url.toLowerCase().contains(D3SView.this.postbackUrl.toLowerCase())) {
                        D3SView.this.postbackHandled = true;
                        view.loadUrl(String.format("javascript:window.%s.processHTML(document.getElementsByTagName('html')[0].innerHTML);", JavaScriptNS));
                        D3SView.this.urlReturned = true;
                    } else {
                        super.onPageStarted(view, url, icon);
                    }
                }
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                if (!failingUrl.startsWith(D3SView.this.postbackUrl)) {
                    D3SView.this.authorizationListener.onAuthorizationWebPageLoadingError(errorCode, description, failingUrl);
                }
            }

            public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
                if (D3SView.this.debugMode) {
                    handler.proceed();
                }
            }
        });
        this.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                if (D3SView.this.authorizationListener != null) {
                    D3SView.this.authorizationListener.onAuthorizationWebPageLoadingProgressChanged(newProgress);
                }
            }
        });
    }

    public D3SView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initUI();
    }

    public D3SView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initUI();
    }

    public D3SView(Context context, AttributeSet attrs, int defStyle, boolean privateBrowsing) {
        super(context, attrs, defStyle);
        this.initUI();
    }

    private void completeAuthorization(String html) {
        Matcher valueMatcher;
        String md = "";
        String pares = "";
        Matcher localMatcher1 = mdFinder.matcher(html);
        Matcher localMatcher2 = paresFinder.matcher(html);
        if (localMatcher1.find()) {
            md = localMatcher1.group(1);
        }
        if (localMatcher2.find()) {
            pares = localMatcher2.group(1);
        }
        if (!TextUtils.isEmpty((CharSequence)md) && (valueMatcher = valuePattern.matcher(md)).find()) {
            md = valueMatcher.group(1);
        }
        if (!TextUtils.isEmpty((CharSequence)pares) && (valueMatcher = valuePattern.matcher(pares)).find()) {
            pares = valueMatcher.group(1);
        }
        if (this.authorizationListener != null) {
            this.urlReturned = false;
            this.postbackHandled = false;
            this.authorizationListener.onAuthorizationCompleted(md, pares);
        }
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public void setAuthorizationListener(D3SSViewAuthorizationListener authorizationListener) {
        this.authorizationListener = authorizationListener;
    }

    public void authorize(String acsUrl, String md, String paReq) {
        this.authorize(acsUrl, md, paReq, null);
    }

    public void authorize(String acsUrl, String md, String paReq, String postbackUrl) {
        String postParams;
        if (this.authorizationListener != null) {
            this.authorizationListener.onAuthorizationStarted(this);
        }
        if (!TextUtils.isEmpty((CharSequence)postbackUrl)) {
            this.postbackUrl = postbackUrl;
        }
        this.urlReturned = false;
        try {
            postParams = String.format(Locale.US, "MD=%1$s&TermUrl=%2$s&PaReq=%3$s", URLEncoder.encode(md, "UTF-8"), URLEncoder.encode(this.postbackUrl, "UTF-8"), URLEncoder.encode(paReq, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.postUrl(acsUrl, postParams.getBytes());
    }

    class D3SJSInterface {
        D3SJSInterface() {
        }

        @JavascriptInterface
        public void processHTML(String paramString) {
            D3SView.this.completeAuthorization(paramString);
        }
    }
}

