package eu.livotov.labs.android.d3s;

/**
 * (c) Livotov Labs Ltd. 2013
 * Alex Askerov, Dmitri Livotov
 * <p/>
 * Date: 20/09/2013
 * <p/>
 * Callback interface to receive authorization events
 */
public interface D3SSViewAuthorizationListener
{

    /**
     * Called when remote banking ACS server finishes 3DS authorization. Now you may pass the returned
     * MD and PaRes parameters to your credit card processing gateway for finalizing the transaction.
     *
     * @param md    MD parameter, sent by ACS server
     * @param paRes paRes parameter, sent by ACS server
     */
    void onAuthorizationCompleted(final String md, final String paRes);

    /**
     * Called when authorization process is started and web page from ACS server is being loaded.
     * It is a good place to show progress dialog or overlay here
     *
     * @param view reference for the DDDSView instance
     */
    void onAuthorizationWebPageLoadingStarted(D3SView view);

    /**
     * Called when auth page finished loading and awaits for cardholder input.
     * It is a good place to dismiss any progress dialogs or overlays here
     *
     * @param view reference for the DDDSView instance
     */
    void onAuthorizationWebPageLoaded(D3SView view);

    /**
     * Called when ACS web page loading progress is updated by a WebView.
     * You can update your progress indications here when needed.
     *
     * @param progress current loading progress from 0 to 100.
     */
    void onAuthorizationWebPageLoadingProgressChanged(int progress);

    /**
     * Called if a loading error occurs
     *
     * @param errorCode
     * @param description
     * @param failingUrl
     */
    void onAuthorizationWebPageLoadingError(int errorCode, String description, String failingUrl);

    /**
     * Called on authorization completion, while in stacked mode.
     * @param finalizationUrl postback url with all extra query parameters that was sent from third-party post-acs server.
     */
    void onAuthorizationCompletedInStackedMode(String finalizationUrl);
}
