/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.d3s;

import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentTransaction;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import eu.livotov.labs.android.d3s.D3SSViewAuthorizationListener;
import eu.livotov.labs.android.d3s.D3SView;
import eu.livotov.labs.android.d3s.R;

public class D3SDialog
extends DialogFragment
implements D3SSViewAuthorizationListener {
    private D3SView authenticator;
    private ProgressBar progressBar;
    private String acs;
    private String md;
    private String pareq;
    private String postback;
    private String stackedModePostbackUrl;
    private D3SDialogListener authorizationListener;
    private Handler handler;

    public static D3SDialog newInstance(String acsUrl, String md, String paReq, D3SDialogListener listener) {
        return D3SDialog.newInstance(acsUrl, md, paReq, null, listener);
    }

    public static D3SDialog newInstance(String acsUrl, String md, String paReq, String postbackUrl, D3SDialogListener listener) {
        D3SDialog dialog = new D3SDialog();
        dialog.acs = acsUrl;
        dialog.md = md;
        dialog.pareq = paReq;
        dialog.postback = postbackUrl;
        dialog.authorizationListener = listener;
        return dialog;
    }

    public static D3SDialog newInstance(String acsUrl, String md, String paReq, String acsPostbackUrl, String stackedModePostbackUrl, D3SDialogListener listener) {
        D3SDialog dialog = new D3SDialog();
        dialog.acs = acsUrl;
        dialog.md = md;
        dialog.pareq = paReq;
        dialog.postback = acsPostbackUrl;
        dialog.stackedModePostbackUrl = stackedModePostbackUrl;
        dialog.authorizationListener = listener;
        return dialog;
    }

    public void showDialogAndAuthenticate(FragmentActivity activity) {
        if (activity.getCurrentFocus() != null) {
            activity.getCurrentFocus().clearFocus();
        }
        try {
            activity.getSupportFragmentManager().executePendingTransactions();
        }
        catch (Throwable err) {
            err.printStackTrace();
        }
        FragmentTransaction ft = activity.getSupportFragmentManager().beginTransaction();
        ft.add((Fragment)this, "d3sdialog");
        ft.commitAllowingStateLoss();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.getDialog().getWindow().requestFeature(1);
        this.getDialog().getWindow().setBackgroundDrawable(null);
        View v = inflater.inflate(R.layout.dialog_3ds, container, false);
        this.progressBar = (ProgressBar)v.findViewById(R.id.progressBar);
        this.authenticator = (D3SView)v.findViewById(R.id.authenticator);
        this.authenticator.setAuthorizationListener(this);
        this.getDialog().setCanceledOnTouchOutside(false);
        this.getDialog().setCancelable(true);
        this.handler = new Handler();
        return v;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (!TextUtils.isEmpty((CharSequence)this.stackedModePostbackUrl)) {
            this.authenticator.setSimpleMode(this.stackedModePostbackUrl);
        }
        if (TextUtils.isEmpty((CharSequence)this.postback)) {
            this.authenticator.authorize(this.acs, this.md, this.pareq);
        } else {
            this.authenticator.authorize(this.acs, this.md, this.pareq, this.postback);
        }
    }

    @Override
    public void onAuthorizationCompleted(final String md, final String paRes) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                D3SDialog.this.dismiss();
                if (D3SDialog.this.authorizationListener != null) {
                    D3SDialog.this.authorizationListener.onAuthorizationCompleted(md, paRes);
                }
            }
        });
    }

    @Override
    public void onAuthorizationStarted(D3SView view) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                D3SDialog.this.progressBar.setVisibility(0);
            }
        });
    }

    @Override
    public void onAuthorizationWebPageLoadingProgressChanged(final int progress) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                D3SDialog.this.progressBar.setVisibility(progress > 0 && progress < 100 ? 0 : 8);
            }
        });
    }

    @Override
    public void onAuthorizationWebPageLoadingError(final int errorCode, final String description, final String failingUrl) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                D3SDialog.this.dismiss();
                if (D3SDialog.this.authorizationListener != null) {
                    D3SDialog.this.authorizationListener.onAuthorizationFailed(errorCode, description, failingUrl);
                }
            }
        });
    }

    @Override
    public void onAuthorizationCompletedInStackedMode(final String finalizationUrl) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                D3SDialog.this.dismiss();
                if (D3SDialog.this.authorizationListener != null) {
                    D3SDialog.this.authorizationListener.onAuthorizationCompletedInStackedMode(finalizationUrl);
                }
            }
        });
    }

    public static interface D3SDialogListener {
        public void onAuthorizationCompleted(String var1, String var2);

        public void onAuthorizationFailed(int var1, String var2, String var3);

        public void onAuthorizationCompletedInStackedMode(String var1);
    }
}

