/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolboxfx.geom;

import eu.hansolo.toolboxfx.geom.Point;
import java.util.ArrayList;
import java.util.List;

public class QuickHull {
    private QuickHull() {
    }

    public static final List<Point> quickHull(List<Point> pointList) {
        ArrayList<Point> points = new ArrayList<Point>(pointList);
        ArrayList<Point> convexHull = new ArrayList<Point>();
        if (points.size() < 3) {
            return (ArrayList)points.clone();
        }
        int minPoint = -1;
        int maxPoint = -1;
        double minX = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        int size = points.size();
        for (int i = 0; i < size; ++i) {
            if (points.get((int)i).x < minX) {
                minX = points.get((int)i).x;
                minPoint = i;
            }
            if (!(points.get((int)i).x > maxX)) continue;
            maxX = points.get((int)i).x;
            maxPoint = i;
        }
        Point minP = points.get(minPoint);
        Point maxP = points.get(maxPoint);
        convexHull.add(minP);
        convexHull.add(maxP);
        points.remove(minP);
        points.remove(maxP);
        ArrayList<Point> leftSet = new ArrayList<Point>();
        ArrayList<Point> rightSet = new ArrayList<Point>();
        for (Point p : points) {
            if (QuickHull.pointLocation(minP, maxP, p) == -1.0) {
                leftSet.add(p);
                continue;
            }
            if (QuickHull.pointLocation(minP, maxP, p) != 1.0) continue;
            rightSet.add(p);
        }
        QuickHull.hullSet(minP, maxP, rightSet, convexHull);
        QuickHull.hullSet(maxP, minP, leftSet, convexHull);
        return convexHull;
    }

    private static final double distance(Point p1, Point p2, Point p3) {
        double ABx = p2.x - p1.x;
        double ABy = p2.y - p1.y;
        double num = ABx * (p1.y - p3.y) - ABy * (p1.x - p3.x);
        if (num < 0.0) {
            num = -num;
        }
        return num;
    }

    private static final void hullSet(Point p1, Point p2, ArrayList<Point> set, List<Point> hull) {
        int insertPosition = hull.indexOf(p2);
        int size = set.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            Point p = set.get(0);
            set.remove(p);
            hull.add(insertPosition, p);
            return;
        }
        double dist = -1.7976931348623157E308;
        int furthestPoint = -1;
        for (int i = 0; i < size; ++i) {
            Point p = set.get(i);
            double distance = QuickHull.distance(p1, p2, p);
            if (!(distance > dist)) continue;
            dist = distance;
            furthestPoint = i;
        }
        Point P = set.get(furthestPoint);
        set.remove(furthestPoint);
        hull.add(insertPosition, P);
        ArrayList<Point> leftSetAP = new ArrayList<Point>();
        for (Point M : set) {
            if (QuickHull.pointLocation(p1, P, M) != 1.0) continue;
            leftSetAP.add(M);
        }
        ArrayList<Point> leftSetPB = new ArrayList<Point>();
        for (Point M : set) {
            if (QuickHull.pointLocation(P, p2, M) != 1.0) continue;
            leftSetPB.add(M);
        }
        QuickHull.hullSet(p1, P, leftSetAP, hull);
        QuickHull.hullSet(P, p2, leftSetPB, hull);
    }

    private static final double pointLocation(Point p1, Point p2, Point p3) {
        double cp1 = (p2.x - p1.x) * (p3.y - p1.y) - (p2.y - p1.y) * (p3.x - p1.x);
        if (cp1 > 0.0) {
            return 1.0;
        }
        if (cp1 == 0.0) {
            return 0.0;
        }
        return -1.0;
    }
}

