/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolboxfx.geom;

import eu.hansolo.toolboxfx.geom.Point;

public class Dimension {
    private int hash = 0;
    private double width;
    private double height;

    public Dimension() {
        this(0.0, 0.0);
    }

    public Dimension(double width, double height) {
        this.width = width;
        this.height = height;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public double getCenterX() {
        return this.width * 0.5;
    }

    public double getCenterY() {
        return this.height * 0.5;
    }

    public Point getCenter() {
        return new Point(this.width * 0.5, this.height * 0.5);
    }

    public void set(double width, double height) {
        this.width = width;
        this.height = height;
    }

    public void set(Dimension dimension) {
        this.width = dimension.getWidth();
        this.height = dimension.getHeight();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Dimension) {
            Dimension other = (Dimension)obj;
            return this.getWidth() == other.getWidth() && this.getHeight() == other.getHeight();
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            long bits = 7L;
            bits = 31L * bits + Double.doubleToLongBits(this.getWidth());
            bits = 31L * bits + Double.doubleToLongBits(this.getHeight());
            this.hash = (int)(bits ^ bits >> 32);
        }
        return this.hash;
    }

    public String toString() {
        return "{" + "\"" + "w" + "\"" + ":" + this.getWidth() + "," + "\"" + "h" + "\"" + ":" + this.getHeight() + "}";
    }
}

