/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolboxfx.geom;

import eu.hansolo.toolbox.Helper;
import eu.hansolo.toolbox.evt.Evt;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import eu.hansolo.toolboxfx.evt.type.BoundsEvt;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class Bounds {
    private double x;
    private double y;
    private double width;
    private double height;
    private Map<EvtType, List<EvtObserver<BoundsEvt>>> observers = new ConcurrentHashMap<EvtType, List<EvtObserver<BoundsEvt>>>();

    public Bounds() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public Bounds(double width, double height) {
        this(0.0, 0.0, width, height);
    }

    public Bounds(double x, double y, double width, double height) {
        this.set(x, y, width, height);
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
        this.fireBoundsEvt(new BoundsEvt(this, BoundsEvt.BOUNDS, this));
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
        this.fireBoundsEvt(new BoundsEvt(this, BoundsEvt.BOUNDS, this));
    }

    public double getMinX() {
        return this.x;
    }

    public double getMaxX() {
        return this.x + this.width;
    }

    public double getMinY() {
        return this.y;
    }

    public double getMaxY() {
        return this.y + this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = Helper.clamp((double)0.0, (double)Double.MAX_VALUE, (double)width);
        this.fireBoundsEvt(new BoundsEvt(this, BoundsEvt.BOUNDS, this));
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = Helper.clamp((double)0.0, (double)Double.MAX_VALUE, (double)height);
        this.fireBoundsEvt(new BoundsEvt(this, BoundsEvt.BOUNDS, this));
    }

    public double getCenterX() {
        return this.x + this.width * 0.5;
    }

    public double getCenterY() {
        return this.y + this.height * 0.5;
    }

    public void set(Bounds bounds) {
        this.set(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    public void set(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.fireBoundsEvt(new BoundsEvt(this, BoundsEvt.BOUNDS, this));
    }

    public boolean contains(double x, double y) {
        return Double.compare(x, this.getMinX()) >= 0 && Double.compare(x, this.getMaxX()) <= 0 && Double.compare(y, this.getMinY()) >= 0 && Double.compare(y, this.getMaxY()) <= 0;
    }

    public boolean intersects(Bounds other) {
        return other.getMaxX() >= this.getMinX() && other.getMaxY() >= this.getMinY() && other.getMinX() <= this.getMaxX() && other.getMinY() <= this.getMaxY();
    }

    public boolean intersects(double x, double y, double width, double height) {
        return x + width >= this.getMinX() && y + height >= this.getMinY() && x <= this.getMaxX() && y <= this.getMaxY();
    }

    public Bounds copy() {
        return new Bounds(this.x, this.y, this.width, this.height);
    }

    public void addBoundsObserver(EvtType<? extends Evt> type, EvtObserver<BoundsEvt> observer) {
        if (!this.observers.containsKey(type)) {
            this.observers.put(type, new CopyOnWriteArrayList());
        }
        if (this.observers.get(type).contains(observer)) {
            return;
        }
        this.observers.get(type).add(observer);
    }

    public void removeBoundsObserver(EvtType<? extends Evt> type, EvtObserver<BoundsEvt> observer) {
        if (this.observers.containsKey(type) && this.observers.get(type).contains(observer)) {
            this.observers.get(type).remove(observer);
        }
    }

    public void removeAllBoundsObservers() {
        this.observers.clear();
    }

    public void fireBoundsEvt(BoundsEvt evt) {
        EvtType<? extends BoundsEvt> type = evt.getEvtType();
        this.observers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(BoundsEvt.ANY)).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle((Evt)evt)));
        if (this.observers.containsKey(type)) {
            this.observers.get(type).forEach(observer -> observer.handle((Evt)evt));
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Bounds) {
            Bounds other = (Bounds)obj;
            return this.getX() == other.getX() && this.getY() == other.getY() && this.getWidth() == other.getWidth() && this.getHeight() == other.getHeight();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.width, this.height);
    }

    public String toString() {
        return "{" + "\"" + "x" + "\"" + ":" + this.getX() + "," + "\"" + "y" + "\"" + ":" + this.getY() + "," + "\"" + "w" + "\"" + ":" + this.getWidth() + "," + "\"" + "h" + "\"" + ":" + this.getHeight() + "}";
    }
}

