/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.monitor.tools;

import java.util.Random;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;

public class Helper {
    public static final double clamp(double min, double max, double value) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static final void enableNode(Node node, boolean enable) {
        node.setManaged(enable);
        node.setVisible(enable);
    }

    public static final Image createNoiseImage(double width, double height, Color darkColor, Color brightColor, double alphaVariationInPercent) {
        if (Double.compare(width, 0.0) <= 0 || Double.compare(height, 0.0) <= 0) {
            return null;
        }
        int w = (int)width;
        int h = (int)height;
        double alphaVariation = Helper.clamp(0.0, 100.0, alphaVariationInPercent);
        WritableImage image = new WritableImage(w, h);
        PixelWriter pixelWriter = image.getPixelWriter();
        Random rndBlackWhite = new Random();
        Random rndAlpha = new Random();
        double alphaStart = alphaVariation / 100.0 / 2.0;
        double variation = alphaVariation / 100.0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                Color NOISE_COLOR = rndBlackWhite.nextBoolean() ? brightColor : darkColor;
                double NOISE_ALPHA = Helper.clamp(0.0, 1.0, alphaStart + rndAlpha.nextDouble() * variation);
                pixelWriter.setColor(x, y, Color.color((double)NOISE_COLOR.getRed(), (double)NOISE_COLOR.getGreen(), (double)NOISE_COLOR.getBlue(), (double)NOISE_ALPHA));
            }
        }
        return image;
    }
}

