/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.monitor;

import eu.hansolo.fx.monitor.Monitor;
import eu.hansolo.fx.monitor.MonitorBuilder;
import eu.hansolo.fx.monitor.tools.ColorTheme;
import eu.hansolo.fx.monitor.tools.Theme;
import eu.hansolo.fx.monitor.tools.Timespan;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class Demo
extends Application {
    private static final Random RND = new Random();
    private ScheduledExecutorService executorService;
    private Runnable sinTask;
    private Monitor monitor;
    private GridPane grid;
    private double t;
    private double step;

    public void init() {
        this.monitor = ((MonitorBuilder)((MonitorBuilder)((MonitorBuilder)((MonitorBuilder)((MonitorBuilder)((MonitorBuilder)((MonitorBuilder)((MonitorBuilder)((MonitorBuilder)((MonitorBuilder)MonitorBuilder.create().lineWidth(2.0)).dotSize(4.0)).rasterVisible(true)).textVisible(true)).glowVisible(true)).crystalOverlayVisible(true)).lineFading(true)).timespan(Timespan.FIVE_SECONDS)).colorTheme(Theme.GREEN)).speedFactor(1.0)).build();
        this.monitor.setOnMouseClicked(e -> {
            if (this.monitor.isRunning()) {
                this.monitor.stop();
            } else {
                this.monitor.start();
            }
        });
        this.t = 0.0;
        this.step = 0.06283185307179587;
        this.sinTask = () -> {
            Platform.runLater(() -> this.monitor.addDataPoint(Math.sin(this.t) * 100.0));
            this.t += this.step;
            if (this.t >= Math.PI * 2) {
                this.t = 0.0;
            }
        };
        this.executorService = Executors.newScheduledThreadPool(1);
        Label themeLabel = new Label("Theme");
        ObservableList themes = FXCollections.observableArrayList(List.of(Theme.values()));
        ComboBox themesComboBox = new ComboBox(themes);
        Label timespanLabel = new Label("Timespan");
        ObservableList timespans = FXCollections.observableArrayList(List.of(Timespan.values()));
        ComboBox timespanComboBox = new ComboBox(timespans);
        CheckBox glowVisibleCheckBox = new CheckBox("Glow");
        CheckBox rasterVisibleCheckBox = new CheckBox("Raster");
        CheckBox textVisibleCheckBox = new CheckBox("Text");
        CheckBox crystalOverlayVisibleCheckBox = new CheckBox("Crystal overlay");
        CheckBox fadingLineCheckBox = new CheckBox("Fading line");
        Label noOfSegmentsLabel = new Label("Length");
        Slider noOfSegmentsSlider = new Slider(0.0, 250.0, 75.0);
        Label dotSizeLabel = new Label("Dot size");
        Slider dotSizeSlider = new Slider(1.0, 5.0, 4.0);
        Label lineWidthLabel = new Label("Line width");
        Slider lineWidthSlider = new Slider(1.0, 5.0, 3.0);
        lineWidthSlider.setBlockIncrement(0.5);
        Label scaleFactorYLabel = new Label("Scale factor y");
        Slider scaleFactorYSlider = new Slider(0.05, 10.0, 1.0);
        scaleFactorYSlider.setBlockIncrement(0.05);
        Label speedFactorLabel = new Label("Speed factor");
        Slider speedFactorSlider = new Slider(0.1, 10.0, 1.0);
        speedFactorSlider.setBlockIncrement(0.1);
        timespanComboBox.getSelectionModel().select((Object)Timespan.FIVE_SECONDS);
        themesComboBox.getSelectionModel().select((Object)Theme.GREEN);
        glowVisibleCheckBox.setSelected(true);
        rasterVisibleCheckBox.setSelected(true);
        textVisibleCheckBox.setSelected(true);
        crystalOverlayVisibleCheckBox.setSelected(true);
        fadingLineCheckBox.setSelected(true);
        this.grid = new GridPane();
        this.grid.setHgap(20.0);
        this.grid.setVgap(10.0);
        this.grid.add((Node)new VBox(new Node[]{themeLabel, themesComboBox}), 0, 0);
        this.grid.add((Node)new VBox(new Node[]{timespanLabel, timespanComboBox}), 0, 1);
        this.grid.add((Node)glowVisibleCheckBox, 0, 2);
        this.grid.add((Node)rasterVisibleCheckBox, 0, 3);
        this.grid.add((Node)textVisibleCheckBox, 0, 4);
        this.grid.add((Node)crystalOverlayVisibleCheckBox, 0, 5);
        this.grid.add((Node)fadingLineCheckBox, 0, 6);
        this.grid.add((Node)new VBox(new Node[]{noOfSegmentsLabel, noOfSegmentsSlider}), 1, 0);
        this.grid.add((Node)new VBox(new Node[]{dotSizeLabel, dotSizeSlider}), 1, 1);
        this.grid.add((Node)new VBox(new Node[]{lineWidthLabel, lineWidthSlider}), 1, 2);
        this.grid.add((Node)new VBox(new Node[]{scaleFactorYLabel, scaleFactorYSlider}), 1, 3);
        this.grid.add((Node)new VBox(new Node[]{speedFactorLabel, speedFactorSlider}), 1, 4);
        themesComboBox.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> this.monitor.setColorTheme((ColorTheme)nv));
        timespanComboBox.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> this.monitor.setTimespan((Timespan)((Object)nv)));
        glowVisibleCheckBox.selectedProperty().addListener((o, ov, nv) -> this.monitor.setGlowVisible((boolean)nv));
        rasterVisibleCheckBox.selectedProperty().addListener((o, ov, nv) -> this.monitor.setRasterVisible((boolean)nv));
        textVisibleCheckBox.selectedProperty().addListener((o, ov, nv) -> this.monitor.setTextVisible((boolean)nv));
        crystalOverlayVisibleCheckBox.selectedProperty().addListener((o, ov, nv) -> this.monitor.setCrystalOverlayVisible((boolean)nv));
        fadingLineCheckBox.selectedProperty().addListener((o, ov, nv) -> this.monitor.setLineFading((boolean)nv));
        noOfSegmentsSlider.valueProperty().addListener((o, ov, nv) -> this.monitor.setNoOfSegments(nv.intValue()));
        dotSizeSlider.valueProperty().addListener((o, ov, nv) -> this.monitor.setDotSize(nv.doubleValue()));
        lineWidthSlider.valueProperty().addListener((o, ov, nv) -> this.monitor.setLineWidth(nv.doubleValue()));
        scaleFactorYSlider.valueProperty().addListener((o, ov, nv) -> this.monitor.setScaleFactorY(nv.doubleValue()));
        speedFactorSlider.valueProperty().addListener((o, ov, nv) -> this.monitor.setSpeedFactor(nv.doubleValue()));
    }

    public void start(Stage stage) {
        StackPane monitorPane = new StackPane(new Node[]{this.monitor});
        VBox pane = new VBox(10.0, new Node[]{monitorPane, this.grid});
        pane.setPadding(new Insets(10.0));
        Scene scene = new Scene((Parent)pane);
        scene.setOnKeyPressed(e -> this.monitor.addDataPoint(RND.nextInt(200) - 100));
        scene.setOnKeyReleased(e -> this.monitor.addDataPoint(0));
        stage.setTitle("JavaFX Monitor");
        stage.setScene(scene);
        stage.show();
        this.executorService.scheduleAtFixedRate(this.sinTask, 0L, 5L, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        System.exit(0);
    }

    public static void main(String[] args) {
        Demo.launch((String[])args);
    }
}

