/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.monitor.tools;

import java.util.concurrent.ArrayBlockingQueue;

public class FixedSizeQueue<E>
extends ArrayBlockingQueue<E> {
    private static final long SERIAL_VERSION_UID = -7772085623838075506L;
    private int size;

    public FixedSizeQueue(int size) {
        super(size);
        this.size = size;
    }

    @Override
    public synchronized boolean add(E element) {
        if (super.size() == this.size) {
            this.remove();
        }
        return super.add(element);
    }

    public E getElementAt(int index) {
        if (index < 0 || index > this.size() - 1) {
            throw new IllegalArgumentException("Index out of bounds.");
        }
        return (E)this.toArray()[index];
    }
}

