/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.monitor;

import eu.hansolo.fx.monitor.Monitor;
import eu.hansolo.fx.monitor.tools.ColorTheme;
import eu.hansolo.fx.monitor.tools.Timespan;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;

public class MonitorBuilder<B extends MonitorBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected MonitorBuilder() {
    }

    public static final MonitorBuilder create() {
        return new MonitorBuilder();
    }

    public final B lineWidth(double lineWidth) {
        this.properties.put("lineWidth", (Property)new SimpleDoubleProperty(lineWidth));
        return (B)this;
    }

    public final B lineColor(Color lineColor) {
        this.properties.put("lineColor", (Property)new SimpleObjectProperty((Object)lineColor));
        return (B)this;
    }

    public final B backgroundColor(Color backgroundColor) {
        this.properties.put("backgroundColor", (Property)new SimpleObjectProperty((Object)backgroundColor));
        return (B)this;
    }

    public final B rasterColor(Color rasterColor) {
        this.properties.put("rasterColor", (Property)new SimpleObjectProperty((Object)rasterColor));
        return (B)this;
    }

    public final B textColor(Color textColor) {
        this.properties.put("textColor", (Property)new SimpleObjectProperty((Object)textColor));
        return (B)this;
    }

    public final B dotSize(double dotSize) {
        this.properties.put("dotSize", (Property)new SimpleDoubleProperty(dotSize));
        return (B)this;
    }

    public final B data(List<Number> data) {
        this.properties.put("data", (Property)new SimpleObjectProperty(data));
        return (B)this;
    }

    public final B rasterVisible(boolean rasterVisible) {
        this.properties.put("rasterVisible", (Property)new SimpleBooleanProperty(rasterVisible));
        return (B)this;
    }

    public final B textVisible(boolean textVisible) {
        this.properties.put("textVisible", (Property)new SimpleBooleanProperty(textVisible));
        return (B)this;
    }

    public final B glowVisible(boolean glowVisible) {
        this.properties.put("glowVisible", (Property)new SimpleBooleanProperty(glowVisible));
        return (B)this;
    }

    public final B lineFading(boolean lineFading) {
        this.properties.put("lineFading", (Property)new SimpleBooleanProperty(lineFading));
        return (B)this;
    }

    public final B crystalOverlayVisible(boolean crystalOveralyVisible) {
        this.properties.put("crystalOverlayVisible", (Property)new SimpleBooleanProperty(crystalOveralyVisible));
        return (B)this;
    }

    public final B colorTheme(ColorTheme colorTheme) {
        this.properties.put("colorTheme", (Property)new SimpleObjectProperty((Object)colorTheme));
        return (B)this;
    }

    public final B timespan(Timespan timespan) {
        this.properties.put("timespan", (Property)new SimpleObjectProperty((Object)timespan));
        return (B)this;
    }

    public final B speedFactor(double speedFactor) {
        this.properties.put("speedFactor", (Property)new SimpleDoubleProperty(speedFactor));
        return (B)this;
    }

    public final B noOfSegments(int noOfSegments) {
        this.properties.put("noOfSegments", (Property)new SimpleIntegerProperty(noOfSegments));
        return (B)this;
    }

    public final B scaleFactorY(double scaleFactorY) {
        this.properties.put("scaleFactorY", (Property)new SimpleDoubleProperty(scaleFactorY));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final Monitor build() {
        Monitor monitor = new Monitor();
        for (String key : this.properties.keySet()) {
            Dimension2D dim;
            if ("prefSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                monitor.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("minSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                monitor.setMinSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("maxSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                monitor.setMaxSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("prefWidth".equals(key)) {
                monitor.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("prefHeight".equals(key)) {
                monitor.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minWidth".equals(key)) {
                monitor.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minHeight".equals(key)) {
                monitor.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxWidth".equals(key)) {
                monitor.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxHeight".equals(key)) {
                monitor.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleX".equals(key)) {
                monitor.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleY".equals(key)) {
                monitor.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutX".equals(key)) {
                monitor.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutY".equals(key)) {
                monitor.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateX".equals(key)) {
                monitor.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateY".equals(key)) {
                monitor.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("padding".equals(key)) {
                monitor.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("lineWidth".equals(key)) {
                monitor.setLineWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("lineColor".equals(key)) {
                monitor.setLineColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("backgroundColor".equals(key)) {
                monitor.setBackgroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("rasterColor".equals(key)) {
                monitor.setRasterColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("textColor".equals(key)) {
                monitor.setTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("dotSize".equals(key)) {
                monitor.setDotSize(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("data".equals(key)) {
                monitor.setData((List)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("rasterVisible".equals(key)) {
                monitor.setRasterVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("textVisible".equals(key)) {
                monitor.setTextVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("glowVisible".equals(key)) {
                monitor.setGlowVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("lineFading".equals(key)) {
                monitor.setLineFading(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("crystalOverlayVisible".equals(key)) {
                monitor.setCrystalOverlayVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("timespan".equals(key)) {
                monitor.setTimespan((Timespan)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("speedFactor".equals(key)) {
                monitor.setSpeedFactor(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("noOfSegments".equals(key)) {
                monitor.setNoOfSegments(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("colorTheme".equals(key)) {
                monitor.setColorTheme((ColorTheme)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"scaleFactorY".equals(key)) continue;
            monitor.setScaleFactorY(((DoubleProperty)this.properties.get(key)).get());
        }
        return monitor;
    }
}

