/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.monitor;

import eu.hansolo.fx.monitor.tools.ColorTheme;
import eu.hansolo.fx.monitor.tools.FixedSizeQueue;
import eu.hansolo.fx.monitor.tools.Helper;
import eu.hansolo.fx.monitor.tools.Point;
import eu.hansolo.fx.monitor.tools.Timespan;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javafx.animation.AnimationTimer;
import javafx.beans.DefaultProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class Monitor
extends Region {
    public static final int DEFAULT_TIMESPAN = Timespan.FIVE_SECONDS.getSeconds();
    public static final double DEFAULT_SPEED = 1.6732;
    public static final double DEFAULT_SPEED_WIDTH_FACTOR = 1.0;
    public static final double DEFAULT_SPEED_FACTOR = 1.0;
    public static final double DEFAULT_LINE_WIDTH = 3.0;
    public static final double DEFAULT_DOT_SIZE = 4.0;
    public static final int DEFAULT_NO_OF_SEGMENTS = 75;
    public static final int MAX_NO_OF_SEGMENTS = 250;
    private static final double PREFERRED_WIDTH = 500.0;
    private static final double PREFERRED_HEIGHT = 200.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 4096.0;
    private static final double MAXIMUM_HEIGHT = 4096.0;
    private static final double[] DASH_ARRAY = new double[]{5.0, 5.0};
    private static final Color DARK_NOISE_COLOR = Color.rgb((int)100, (int)100, (int)100, (double)0.1);
    private static final Color BRIGHT_NOISE_COLOR = Color.rgb((int)200, (int)200, (int)200, (double)0.05);
    private double width;
    private double height;
    private Canvas bkgCanvas;
    private GraphicsContext bkgCtx;
    private Canvas lineCanvas;
    private GraphicsContext lineCtx;
    private Canvas dotCanvas;
    private GraphicsContext dotCtx;
    private Pane pane;
    private int timespan = DEFAULT_TIMESPAN;
    private double speed = 1.6732 * (double)DEFAULT_TIMESPAN / (double)this.timespan;
    private double speedWidthFactor = 1.0;
    private double speedFactor = 1.0;
    private double currentSpeed = this.speed * this.speedWidthFactor;
    private double rasterWidth = 100.0;
    private double rasterSubWidth = this.rasterWidth / 5.0;
    private double lineWidth = 3.0;
    private int noOfSegments = 75;
    private int index = 0;
    private List<Number> data = new ArrayList<Number>();
    private Number dataPoint = 0;
    private Number lastDataPoint = 0;
    private Color backgroundColor = Color.BLACK;
    private Color rasterColor;
    private Color textColor;
    private Color lineColor = Color.CYAN;
    private ImageView crystalOverlay;
    private Image crystalImage = Helper.createNoiseImage(500.0, 200.0, DARK_NOISE_COLOR, BRIGHT_NOISE_COLOR, 8.0);
    private boolean rasterVisible = true;
    private boolean textVisible = true;
    private boolean glowVisible = true;
    private boolean lineFading = true;
    private boolean crystalOverlayVisible = true;
    private Font font;
    private double centerY = 100.0;
    private double x = 0.0;
    private double y = 0.0;
    private double delta;
    private double scaleFactorY = 1.0;
    private double red;
    private double green;
    private double blue;
    private double dotSize = 4.0;
    private double dotRadius;
    private RadialGradient dotGradient;
    private DropShadow glow;
    private boolean running = false;
    private AnimationTimer timer;
    private FixedSizeQueue<Point> queue;
    private double[] lastP;

    public Monitor() {
        this.crystalOverlay = new ImageView(this.crystalImage);
        this.font = Font.font((double)10.0);
        this.red = this.lineColor.getRed();
        this.green = this.lineColor.getGreen();
        this.blue = this.lineColor.getBlue();
        this.rasterColor = Color.color((double)this.red, (double)this.green, (double)this.blue, (double)0.35);
        this.textColor = Color.color((double)this.red, (double)this.green, (double)this.blue, (double)0.75);
        this.dotRadius = this.dotSize * 0.5;
        this.dotGradient = new RadialGradient(0.0, 0.0, this.x, this.y, 2.5, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.WHITE), new Stop(0.2, Color.WHITE), new Stop(1.0, this.lineColor)});
        this.glow = new DropShadow(BlurType.TWO_PASS_BOX, this.lineColor, 10.0, 0.8, 0.0, 0.0);
        this.queue = new FixedSizeQueue((int)((double)this.noOfSegments / this.speed));
        this.lastP = new double[]{0.0, this.centerY};
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                Monitor.this.drawLine();
                Monitor.this.drawDot();
            }
        };
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(500.0, 200.0);
            }
        }
        this.bkgCanvas = new Canvas(this.getPrefWidth(), this.getPrefHeight());
        this.bkgCtx = this.bkgCanvas.getGraphicsContext2D();
        this.bkgCtx.setLineJoin(StrokeLineJoin.ROUND);
        this.bkgCtx.setLineCap(StrokeLineCap.BUTT);
        this.bkgCtx.setLineWidth(1.0);
        this.bkgCtx.setTextAlign(TextAlignment.RIGHT);
        this.lineCanvas = new Canvas(this.getPrefWidth(), this.getPrefHeight());
        this.lineCtx = this.lineCanvas.getGraphicsContext2D();
        this.lineCtx.setLineJoin(StrokeLineJoin.ROUND);
        this.lineCtx.setLineCap(StrokeLineCap.BUTT);
        this.lineCtx.setLineWidth(this.lineWidth);
        this.dotCanvas = new Canvas(this.getPrefWidth(), this.getPrefHeight());
        this.dotCtx = this.dotCanvas.getGraphicsContext2D();
        Helper.enableNode((Node)this.crystalOverlay, this.crystalOverlayVisible);
        this.pane = new Pane(new Node[]{this.bkgCanvas, this.lineCanvas, this.dotCanvas, this.crystalOverlay});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 4096.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 4096.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = Helper.clamp(0.5, 5.0, lineWidth);
    }

    public double getDotSize() {
        return this.dotSize;
    }

    public void setDotSize(double dotSize) {
        this.dotSize = Helper.clamp(1.0, 5.0, dotSize);
        this.dotRadius = this.dotSize * 0.5;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
        this.red = lineColor.getRed();
        this.green = lineColor.getGreen();
        this.blue = lineColor.getBlue();
        this.dotGradient = new RadialGradient(0.0, 0.0, this.x, this.y, 2.5, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.WHITE), new Stop(0.2, Color.WHITE), new Stop(1.0, lineColor)});
        this.glow = new DropShadow(BlurType.TWO_PASS_BOX, lineColor, 10.0, 0.8, 0.0, 0.0);
        this.redraw();
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.redraw();
    }

    public Color getRasterColor() {
        return this.rasterColor;
    }

    public void setRasterColor(Color rasterColor) {
        this.rasterColor = rasterColor;
        this.redraw();
    }

    public void setRasterColorToLineColor() {
        this.rasterColor = Color.color((double)this.red, (double)this.green, (double)this.blue, (double)0.35);
        this.redraw();
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
        this.redraw();
    }

    public void setTextColorToLineColor() {
        this.textColor = Color.color((double)this.red, (double)this.green, (double)this.blue, (double)0.75);
        this.redraw();
    }

    public boolean isRasterVisible() {
        return this.rasterVisible;
    }

    public void setRasterVisible(boolean rasterVisible) {
        this.rasterVisible = rasterVisible;
        this.redraw();
    }

    public boolean isTextVisible() {
        return this.textVisible;
    }

    public void setTextVisible(boolean textVisible) {
        this.textVisible = textVisible;
        this.redraw();
    }

    public boolean isGlowVisible() {
        return this.glowVisible;
    }

    public void setGlowVisible(boolean glowVisible) {
        this.glowVisible = glowVisible;
        this.redraw();
    }

    public boolean isLineFading() {
        return this.lineFading;
    }

    public void setLineFading(boolean lineFading) {
        this.lineFading = lineFading;
        this.redraw();
    }

    public boolean isCrystalOverlayVisible() {
        return this.crystalOverlayVisible;
    }

    public void setCrystalOverlayVisible(boolean crystalOverlayVisible) {
        this.crystalOverlayVisible = crystalOverlayVisible;
        Helper.enableNode((Node)this.crystalOverlay, crystalOverlayVisible);
        this.redraw();
    }

    public void setColorTheme(ColorTheme colorTheme) {
        this.backgroundColor = colorTheme.getBackgroundColor();
        this.lineColor = colorTheme.getLineColor();
        this.rasterColor = colorTheme.getRasterColor();
        this.textColor = colorTheme.getTextColor();
        this.red = this.lineColor.getRed();
        this.green = this.lineColor.getGreen();
        this.blue = this.lineColor.getBlue();
        this.dotGradient = new RadialGradient(0.0, 0.0, this.x, this.y, 2.5, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.WHITE), new Stop(0.2, Color.WHITE), new Stop(1.0, this.lineColor)});
        this.glow = new DropShadow(BlurType.TWO_PASS_BOX, this.lineColor, 10.0, 0.8, 0.0, 0.0);
        this.redraw();
    }

    public int getTimespan() {
        return this.timespan;
    }

    public void setTimespan(Timespan timespan) {
        if (this.isRunning()) {
            this.timer.stop();
            this.timespan = timespan.getSeconds();
            this.speed = 1.6732 * (double)DEFAULT_TIMESPAN / (double)this.timespan;
            this.currentSpeed = this.speed * this.speedWidthFactor * this.speedFactor;
            this.timer.start();
        } else {
            this.timespan = timespan.getSeconds();
            this.speed = 1.6732 * (double)DEFAULT_TIMESPAN / (double)this.timespan;
            this.currentSpeed = this.speed * this.speedWidthFactor * this.speedFactor;
        }
    }

    public void setSpeedFactor(double speedFactor) {
        this.speedFactor = Helper.clamp(0.1, 10.0, speedFactor);
        if (this.running) {
            this.timer.stop();
            this.currentSpeed = this.speed * this.speedWidthFactor * speedFactor;
            this.timer.start();
        } else {
            this.currentSpeed = this.speed * this.speedWidthFactor * speedFactor;
        }
    }

    public int getNoOfSegments() {
        return this.noOfSegments;
    }

    public void setNoOfSegments(int noOfSegments) {
        this.noOfSegments = noOfSegments < 1 ? 1 : (noOfSegments > 250 || this.width > 0.0 && (double)noOfSegments > this.width ? (this.width > 0.0 && (double)noOfSegments > this.width ? (int)this.width : 250) : noOfSegments);
        this.adjustQueueSize();
    }

    public List<Number> getData() {
        return this.data;
    }

    public void setData(List<Number> data) {
        if (null == data) {
            throw new IllegalArgumentException("Data cannot be null");
        }
        double maxValue = Math.abs(data.stream().mapToDouble(Number::doubleValue).max().getAsDouble());
        double minValue = Math.abs(data.stream().mapToDouble(Number::doubleValue).min().getAsDouble());
        this.delta = Math.max(minValue, maxValue);
        if (this.delta > this.height) {
            this.scaleFactorY = this.height * 0.5 / this.delta * 0.75;
        }
        this.queue.clear();
        if (this.running) {
            this.stop();
            this.data = data;
            this.index = 0;
            this.start();
        } else {
            this.data = data;
            this.index = 0;
        }
    }

    public void addDataPoint(Number dataPoint) {
        if (null == dataPoint) {
            return;
        }
        this.dataPoint = dataPoint;
    }

    public double getScaleFactorY() {
        return this.scaleFactorY;
    }

    public void setScaleFactorY(double scaleFactorY) {
        this.scaleFactorY = Helper.clamp(0.05, 10.0, scaleFactorY);
    }

    public void start() {
        this.timer.start();
        this.running = true;
    }

    public void stop() {
        this.timer.stop();
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    private void adjustQueueSize() {
        int queueSize = (int)((double)this.noOfSegments / this.speed);
        if (queueSize < 1) {
            queueSize = 1;
        }
        if (queueSize > 250) {
            queueSize = 250;
        }
        if (this.running) {
            this.timer.stop();
            this.queue = new FixedSizeQueue(queueSize);
            this.timer.start();
        } else {
            this.queue = new FixedSizeQueue(queueSize);
        }
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        this.centerY = this.height / 2.0;
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            this.pane.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.bkgCanvas.setWidth(this.width);
            this.bkgCanvas.setHeight(this.height);
            this.lineCanvas.setWidth(this.width);
            this.lineCanvas.setHeight(this.height);
            this.dotCanvas.setWidth(this.width);
            this.dotCanvas.setHeight(this.height);
            if (this.crystalOverlay.isVisible()) {
                this.crystalOverlay.setCache(false);
                this.crystalOverlay.setImage(Helper.createNoiseImage(this.width, this.height, DARK_NOISE_COLOR, BRIGHT_NOISE_COLOR, 8.0));
                this.crystalOverlay.setCache(true);
            }
            if (!this.data.isEmpty()) {
                this.scaleFactorY = this.height * 0.5 / this.delta * 0.75;
            }
            this.font = Font.font((double)(this.height * 0.05));
            this.rasterWidth = this.width / (double)this.timespan;
            this.rasterSubWidth = this.rasterWidth / 5.0;
            this.speedWidthFactor = this.width / 500.0;
            this.currentSpeed = this.speed * this.speedWidthFactor * this.speedFactor;
            this.redraw();
        }
    }

    private void drawBackground() {
        this.bkgCtx.clearRect(0.0, 0.0, this.width, this.height);
        this.bkgCtx.setFill((Paint)this.backgroundColor);
        this.bkgCtx.fillRect(0.0, 0.0, this.width, this.height);
        if (this.rasterVisible) {
            this.bkgCtx.setStroke((Paint)this.rasterColor);
            this.bkgCtx.setFill((Paint)this.textColor);
            this.bkgCtx.setLineDashes(null);
            this.bkgCtx.strokeLine(0.0, this.centerY, this.width, this.centerY);
            this.bkgCtx.setFont(this.font);
            this.bkgCtx.setLineDashes(DASH_ARRAY);
            double distanceYFromCenter = this.font.getSize() * 1.0;
            double speedRatio = 1.6732 / this.speed;
            double timespanRatio = (double)this.timespan / (double)DEFAULT_TIMESPAN;
            double textValueFactor = speedRatio / timespanRatio / this.speedFactor;
            for (int i = 0; i < this.timespan; ++i) {
                this.bkgCtx.strokeLine((double)i * this.rasterWidth, 0.0, (double)i * this.rasterWidth, this.height);
                this.bkgCtx.save();
                this.bkgCtx.setLineDashes(null);
                for (int j = 1; j < 5; ++j) {
                    this.bkgCtx.strokeLine((double)i * this.rasterWidth + (double)j * this.rasterSubWidth, this.centerY - 3.0, (double)i * this.rasterWidth + (double)j * this.rasterSubWidth, this.centerY + 3.0);
                }
                this.bkgCtx.restore();
                if (!this.textVisible) continue;
                this.bkgCtx.fillText(String.format(Locale.US, "%.1f", (double)(i + 1) * textValueFactor), (double)(i + 1) * this.rasterWidth - 5.0, this.centerY + distanceYFromCenter);
            }
        }
    }

    private void drawLine() {
        if (!this.running) {
            return;
        }
        this.lineCtx.setLineWidth(this.lineWidth);
        this.x += this.currentSpeed;
        if (this.data.isEmpty()) {
            if (null != this.dataPoint) {
                this.lastDataPoint = this.dataPoint;
                this.y = this.dataPoint.doubleValue() * this.scaleFactorY;
                this.queue.add(new Point(this.x, this.centerY + this.y));
                this.dataPoint = null;
            } else {
                this.y = this.lastDataPoint.doubleValue() * this.scaleFactorY;
                this.queue.add(new Point(this.x, this.centerY + this.y));
            }
        } else {
            int n;
            if (++this.index >= this.data.size()) {
                n = this.index = 0;
            } else {
                int n2 = this.index;
                n = n2;
                this.index = n2 + 1;
            }
            this.y = -this.data.get(n).doubleValue() * this.scaleFactorY;
            this.queue.add(new Point(this.x, this.centerY + this.y));
        }
        Point[] points = this.queue.toArray(new Point[0]);
        long length = points.length;
        if (this.lineFading) {
            this.lineCtx.clearRect(0.0, 0.0, this.width, this.height);
            double fadeStep = 1.0 / (double)points.length;
            int i = 0;
            while ((long)i < length - 1L) {
                if (points[i].x < points[i + 1].x) {
                    this.lineCtx.beginPath();
                    this.lineCtx.moveTo(points[i].x, points[i].y);
                    this.lineCtx.lineTo(points[i + 1].x, points[i + 1].y);
                    this.lineCtx.setStroke((Paint)Color.color((double)this.red, (double)this.green, (double)this.blue, (double)((double)i * fadeStep)));
                    this.lineCtx.stroke();
                }
                ++i;
            }
        } else {
            this.lineCtx.setLineWidth(this.lineWidth);
            this.lineCtx.setStroke((Paint)this.lineColor);
            double pY = this.centerY + this.y;
            if (this.x > this.lastP[0]) {
                this.lineCtx.strokeLine(this.lastP[0], this.lastP[1], this.x, pY);
            } else {
                this.lineCtx.strokeLine(this.x, pY, this.x, pY);
            }
            this.lineCtx.clearRect(this.x + 1.0, 0.0, 20.0, this.height);
            this.lastP[0] = this.x;
            this.lastP[1] = pY;
        }
        if (this.x > this.width) {
            this.x = -this.currentSpeed;
        }
    }

    private void drawDot() {
        if (!this.running) {
            return;
        }
        this.dotCtx.clearRect(0.0, 0.0, this.width, this.height);
        this.dotCtx.save();
        this.dotCtx.setEffect((Effect)(this.glowVisible ? this.glow : null));
        this.dotCtx.setFill((Paint)this.dotGradient);
        this.dotCtx.fillOval(this.x - this.dotRadius, this.centerY + this.y - this.dotRadius, this.dotSize, this.dotSize);
        this.dotCtx.restore();
    }

    private void redraw() {
        this.drawBackground();
        this.drawLine();
        this.drawDot();
    }
}

