/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessArchivalData;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;

public class AcceptableBasicTimestampValidationCheck
extends ChainItem<XmlValidationProcessArchivalData> {
    private final TimestampWrapper timestamp;
    private final XmlConstraintsConclusion basicTimestampValidation;
    private Indication bbbIndication;
    private SubIndication bbbSubIndication;

    public AcceptableBasicTimestampValidationCheck(I18nProvider i18nProvider, XmlValidationProcessArchivalData result, TimestampWrapper timestamp, XmlConstraintsConclusion basicTimestampValidation, LevelConstraint constraint) {
        super(i18nProvider, result, constraint, timestamp.getId());
        this.timestamp = timestamp;
        this.basicTimestampValidation = basicTimestampValidation;
    }

    @Override
    protected XmlBlockType getBlockType() {
        return XmlBlockType.TST_BBB;
    }

    @Override
    protected boolean process() {
        if (this.basicTimestampValidation != null && this.basicTimestampValidation.getConclusion() != null) {
            XmlConclusion conclusion = this.basicTimestampValidation.getConclusion();
            this.bbbIndication = conclusion.getIndication();
            this.bbbSubIndication = conclusion.getSubIndication();
            return ValidationProcessUtils.isAllowedBasicTimestampValidation(conclusion);
        }
        return false;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.ARCH_IRTVBBA;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.ARCH_IRTVBBA_ANS;
    }

    @Override
    protected String buildAdditionalInfo() {
        String date = ValidationProcessUtils.getFormattedDate(this.timestamp.getProductionTime());
        return this.i18nProvider.getMessage(MessageTag.TIMESTAMP_VALIDATION, new Object[]{ValidationProcessUtils.getTimestampTypeMessageTag(this.timestamp.getType()), this.timestamp.getId(), date});
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.bbbIndication;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.bbbSubIndication;
    }
}

