/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.signature;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusionWithProofOfExistence;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTLAnalysis;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationCertificateQualification;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationSignatureQualification;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.enumerations.CertificateQualification;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SignatureQualification;
import eu.europa.esig.dss.enumerations.ValidationTime;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.qualification.certificate.CertQualificationAtTimeBlock;
import eu.europa.esig.dss.validation.process.qualification.certificate.FinalCertificateQualificationCalculator;
import eu.europa.esig.dss.validation.process.qualification.signature.SigQualificationMatrix;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.AcceptableListOfTrustedListsCheck;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.AcceptableTrustedListCheck;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.AcceptableTrustedListPresenceCheck;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.AdESAcceptableCheck;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.CertificateTypeAtSigningTimeCheck;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.QSCDCertificateAtSigningTimeCheck;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.QualifiedCertificateAtCertificateIssuanceCheck;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.QualifiedCertificateAtSigningTimeCheck;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.TrustedListReachedForCertificateChainCheck;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustedServiceFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustedServicesFilterFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SignatureQualificationBlock
extends Chain<XmlValidationSignatureQualification> {
    private final XmlConclusion etsi319102Conclusion;
    private final Date bestSignatureTime;
    private final CertificateWrapper signingCertificate;
    private final List<XmlTLAnalysis> tlAnalysis;
    private final List<XmlTLAnalysis> relatedTLAnalyses = new ArrayList<XmlTLAnalysis>();
    private CertificateQualification qualificationAtIssuanceTime;
    private CertificateQualification qualificationAtSigningTime;

    public SignatureQualificationBlock(I18nProvider i18nProvider, XmlConstraintsConclusionWithProofOfExistence etsi319102validation, CertificateWrapper signingCertificate, List<XmlTLAnalysis> tlAnalysis) {
        super(i18nProvider, new XmlValidationSignatureQualification());
        this.etsi319102Conclusion = etsi319102validation.getConclusion();
        this.bestSignatureTime = etsi319102validation.getProofOfExistence().getTime();
        this.signingCertificate = signingCertificate;
        this.tlAnalysis = tlAnalysis;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.SIG_QUALIFICATION;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlValidationSignatureQualification> item = this.firstItem = this.isAdES(this.etsi319102Conclusion);
        item = item.setNextItem(this.isTrustedListReachedForCertificateChain(this.signingCertificate));
        if (this.signingCertificate != null && this.signingCertificate.isTrustedListReached()) {
            List originalTSPs = this.signingCertificate.getTrustedServices();
            Set listOfTrustedListUrls = originalTSPs.stream().filter(t -> t.getListOfTrustedLists() != null).map(t -> t.getListOfTrustedLists().getUrl()).collect(Collectors.toSet());
            HashSet<String> acceptableLOTLUrls = new HashSet<String>();
            for (String lotlURL : listOfTrustedListUrls) {
                XmlTLAnalysis lotlAnalysis = this.getTlAnalysis(lotlURL);
                if (lotlAnalysis == null) continue;
                this.relatedTLAnalyses.add(lotlAnalysis);
                AcceptableListOfTrustedListsCheck<XmlValidationSignatureQualification> acceptableLOTL = this.isAcceptableLOTL(lotlAnalysis);
                item = item.setNextItem(acceptableLOTL);
                if (!acceptableLOTL.process()) continue;
                acceptableLOTLUrls.add(lotlURL);
            }
            Set trustedListUrls = originalTSPs.stream().filter(t -> t.getTrustedList() != null && (t.getListOfTrustedLists() == null || acceptableLOTLUrls.contains(t.getListOfTrustedLists().getUrl()))).map(t -> t.getTrustedList().getUrl()).collect(Collectors.toSet());
            HashSet<String> acceptableTLUrls = new HashSet<String>();
            if (Utils.isCollectionNotEmpty(trustedListUrls)) {
                for (String tlURL : trustedListUrls) {
                    XmlTLAnalysis currentTL = this.getTlAnalysis(tlURL);
                    if (currentTL == null) continue;
                    this.relatedTLAnalyses.add(currentTL);
                    AcceptableTrustedListCheck<XmlValidationSignatureQualification> acceptableTL = this.isAcceptableTL(currentTL);
                    item = item.setNextItem(acceptableTL);
                    if (!acceptableTL.process()) continue;
                    acceptableTLUrls.add(tlURL);
                }
            }
            item = item.setNextItem(this.isAcceptableTLPresent(acceptableTLUrls));
            if (Utils.isCollectionNotEmpty(acceptableTLUrls)) {
                TrustedServiceFilter filter = TrustedServicesFilterFactory.createFilterByUrls(acceptableTLUrls);
                List<TrustedServiceWrapper> acceptableServices = filter.filter(originalTSPs);
                filter = TrustedServicesFilterFactory.createFilterByCaQc();
                List<TrustedServiceWrapper> caqcServices = filter.filter(acceptableServices);
                CertQualificationAtTimeBlock certQualAtIssuanceBlock = new CertQualificationAtTimeBlock(this.i18nProvider, ValidationTime.CERTIFICATE_ISSUANCE_TIME, this.signingCertificate, caqcServices);
                XmlValidationCertificateQualification certQualAtIssuanceResult = (XmlValidationCertificateQualification)certQualAtIssuanceBlock.execute();
                ((XmlValidationSignatureQualification)this.result).getValidationCertificateQualification().add(certQualAtIssuanceResult);
                this.qualificationAtIssuanceTime = certQualAtIssuanceResult.getCertificateQualification();
                CertQualificationAtTimeBlock certQualAtSigningTimeBlock = new CertQualificationAtTimeBlock(this.i18nProvider, ValidationTime.BEST_SIGNATURE_TIME, this.bestSignatureTime, this.signingCertificate, caqcServices);
                XmlValidationCertificateQualification certQualAtSigningTimeResult = (XmlValidationCertificateQualification)certQualAtSigningTimeBlock.execute();
                ((XmlValidationSignatureQualification)this.result).getValidationCertificateQualification().add(certQualAtSigningTimeResult);
                this.qualificationAtSigningTime = certQualAtSigningTimeResult.getCertificateQualification();
                item = item.setNextItem(this.qualifiedCertificateAtSigningTime(this.qualificationAtSigningTime));
                item = item.setNextItem(this.certificateTypeAtSigningTime(this.qualificationAtSigningTime));
                item = item.setNextItem(this.qualifiedCertificateAtIssuance(this.qualificationAtIssuanceTime));
                item = item.setNextItem(this.qscdAtSigningTime(this.qualificationAtSigningTime));
            }
        }
    }

    private XmlTLAnalysis getTlAnalysis(String url) {
        for (XmlTLAnalysis xmlTLAnalysis : this.tlAnalysis) {
            if (!Utils.areStringsEqual((String)url, (String)xmlTLAnalysis.getURL())) continue;
            return xmlTLAnalysis;
        }
        return null;
    }

    @Override
    protected void addAdditionalInfo() {
        this.setIndication();
        this.determineFinalQualification();
    }

    @Override
    protected void collectAdditionalMessages(XmlConclusion conclusion) {
        for (XmlValidationCertificateQualification certQualAtTime : ((XmlValidationSignatureQualification)this.result).getValidationCertificateQualification()) {
            this.collectAllMessages(conclusion, certQualAtTime.getConclusion());
        }
        for (XmlTLAnalysis relatedTLAnalysis : this.relatedTLAnalyses) {
            this.collectAllMessages(conclusion, relatedTLAnalysis.getConclusion());
        }
    }

    private void determineFinalQualification() {
        SignatureQualification sigQualif = SignatureQualification.NA;
        if (this.etsi319102Conclusion != null && this.qualificationAtIssuanceTime != null && this.qualificationAtSigningTime != null) {
            FinalCertificateQualificationCalculator certificateQualificationCalculator = new FinalCertificateQualificationCalculator(this.qualificationAtIssuanceTime, this.qualificationAtSigningTime);
            CertificateQualification finalCertQualification = certificateQualificationCalculator.getFinalQualification();
            sigQualif = SigQualificationMatrix.getSignatureQualification(this.etsi319102Conclusion.getIndication(), finalCertQualification);
        }
        ((XmlValidationSignatureQualification)this.result).setSignatureQualification(sigQualif);
    }

    private void setIndication() {
        XmlConclusion conclusion = ((XmlValidationSignatureQualification)this.result).getConclusion();
        if (conclusion != null) {
            if (Utils.isCollectionNotEmpty((Collection)conclusion.getErrors())) {
                conclusion.setIndication(Indication.FAILED);
            } else if (Utils.isCollectionNotEmpty((Collection)conclusion.getWarnings())) {
                conclusion.setIndication(Indication.INDETERMINATE);
            } else {
                conclusion.setIndication(Indication.PASSED);
            }
        }
    }

    private ChainItem<XmlValidationSignatureQualification> isTrustedListReachedForCertificateChain(CertificateWrapper signingCertificate) {
        return new TrustedListReachedForCertificateChainCheck<XmlValidationSignatureQualification>(this.i18nProvider, (XmlValidationSignatureQualification)this.result, signingCertificate, this.getFailLevelConstraint());
    }

    private AcceptableListOfTrustedListsCheck<XmlValidationSignatureQualification> isAcceptableLOTL(XmlTLAnalysis xmlLOTLAnalysis) {
        return new AcceptableListOfTrustedListsCheck<XmlValidationSignatureQualification>(this.i18nProvider, (XmlValidationSignatureQualification)this.result, xmlLOTLAnalysis, this.getWarnLevelConstraint());
    }

    private AcceptableTrustedListCheck<XmlValidationSignatureQualification> isAcceptableTL(XmlTLAnalysis xmlTLAnalysis) {
        return new AcceptableTrustedListCheck<XmlValidationSignatureQualification>(this.i18nProvider, (XmlValidationSignatureQualification)this.result, xmlTLAnalysis, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationSignatureQualification> isAcceptableTLPresent(Set<String> acceptableUrls) {
        return new AcceptableTrustedListPresenceCheck<XmlValidationSignatureQualification>(this.i18nProvider, (XmlValidationSignatureQualification)this.result, acceptableUrls, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationSignatureQualification> isAdES(XmlConclusion etsi319102Conclusion) {
        return new AdESAcceptableCheck(this.i18nProvider, (XmlValidationSignatureQualification)this.result, etsi319102Conclusion, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationSignatureQualification> qualifiedCertificateAtSigningTime(CertificateQualification qualificationAtSigningTime) {
        return new QualifiedCertificateAtSigningTimeCheck(this.i18nProvider, (XmlValidationSignatureQualification)this.result, qualificationAtSigningTime, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationSignatureQualification> certificateTypeAtSigningTime(CertificateQualification qualificationAtSigningTime) {
        return new CertificateTypeAtSigningTimeCheck(this.i18nProvider, (XmlValidationSignatureQualification)this.result, qualificationAtSigningTime, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationSignatureQualification> qualifiedCertificateAtIssuance(CertificateQualification qualificationAtIssuance) {
        return new QualifiedCertificateAtCertificateIssuanceCheck(this.i18nProvider, (XmlValidationSignatureQualification)this.result, qualificationAtIssuance, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationSignatureQualification> qscdAtSigningTime(CertificateQualification qualificationAtSigningTime) {
        return new QSCDCertificateAtSigningTimeCheck(this.i18nProvider, (XmlValidationSignatureQualification)this.result, qualificationAtSigningTime, this.getWarnLevelConstraint());
    }
}

