/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.checks.qualified;

import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.validation.process.qualification.EIDASUtils;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qualified.QualificationByCertificatePostEIDAS;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qualified.QualificationByCertificatePreEIDAS;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qualified.QualificationByTL;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qualified.QualificationStrategy;

public final class QualificationStrategyFactory {
    private QualificationStrategyFactory() {
    }

    public static QualificationStrategy createQualificationFromCert(CertificateWrapper signingCertificate) {
        if (EIDASUtils.isPostEIDAS(signingCertificate.getNotBefore())) {
            return new QualificationByCertificatePostEIDAS(signingCertificate);
        }
        return new QualificationByCertificatePreEIDAS(signingCertificate);
    }

    public static QualificationStrategy createQualificationFromTL(TrustedServiceWrapper trustedService, QualificationStrategy qualifiedInCert) {
        return new QualificationByTL(trustedService, qualifiedInCert);
    }

    public static QualificationStrategy createQualificationFromCertAndTL(CertificateWrapper signingCertificate, TrustedServiceWrapper caQcTrustedService) {
        QualificationStrategy qcFromCert = QualificationStrategyFactory.createQualificationFromCert(signingCertificate);
        return QualificationStrategyFactory.createQualificationFromTL(caQcTrustedService, qcFromCert);
    }
}

