/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicValidation;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.diagnostic.AbstractTokenProxy;
import eu.europa.esig.dss.diagnostic.CertificateRefWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.SubContext;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.CryptographicChecker;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.DigestCryptographicChecker;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.AllCertificatesInPathReferencedCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicCheckerResultCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.DigestMatcherCryptographicCheckerResultCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.SigningCertificateAttributePresentCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.SigningCertificateRefDigestCryptographicCheckerResultCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.SigningCertificateReferencesValidityCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.UnicitySigningCertificateAttributeCheck;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public abstract class AbstractAcceptanceValidation<T extends AbstractTokenProxy>
extends Chain<XmlSAV> {
    protected final T token;
    protected final Date currentTime;
    protected final Context context;
    protected final ValidationPolicy validationPolicy;
    private XmlCryptographicValidation cryptographicValidation;

    protected AbstractAcceptanceValidation(I18nProvider i18nProvider, T token, Date currentTime, Context context, ValidationPolicy validationPolicy) {
        super(i18nProvider, new XmlSAV());
        this.token = token;
        this.currentTime = currentTime;
        this.context = context;
        this.validationPolicy = validationPolicy;
    }

    protected ChainItem<XmlSAV> signingCertificateAttributePresent() {
        LevelConstraint constraint = this.validationPolicy.getSigningCertificateAttributePresentConstraint(this.context);
        return new SigningCertificateAttributePresentCheck(this.i18nProvider, (XmlSAV)this.result, (TokenProxy)this.token, constraint);
    }

    protected ChainItem<XmlSAV> unicitySigningCertificateAttribute() {
        LevelConstraint constraint = this.validationPolicy.getUnicitySigningCertificateAttributeConstraint(this.context);
        return new UnicitySigningCertificateAttributeCheck(this.i18nProvider, (XmlSAV)this.result, (TokenProxy)this.token, constraint);
    }

    protected ChainItem<XmlSAV> signingCertificateReferencesValidity() {
        LevelConstraint constraint = this.validationPolicy.getSigningCertificateRefersCertificateChainConstraint(this.context);
        return new SigningCertificateReferencesValidityCheck(this.i18nProvider, (XmlSAV)this.result, (TokenProxy)this.token, constraint);
    }

    protected ChainItem<XmlSAV> allCertificatesInPathReferenced() {
        LevelConstraint constraint = this.validationPolicy.getReferencesToAllCertificateChainPresentConstraint(this.context);
        return new AllCertificatesInPathReferencedCheck(this.i18nProvider, (XmlSAV)this.result, (TokenProxy)this.token, constraint);
    }

    protected ChainItem<XmlSAV> cryptographic(ChainItem<XmlSAV> item) {
        CryptographicConstraint constraint = this.validationPolicy.getSignatureCryptographicConstraint(this.context);
        MessageTag position = ValidationProcessUtils.getCryptoPosition(this.context);
        CryptographicChecker cc = new CryptographicChecker(this.i18nProvider, (TokenProxy)this.token, this.currentTime, position, constraint);
        XmlCC ccResult = (XmlCC)cc.execute();
        if (item == null) {
            this.firstItem = this.cryptographicCheckResult(ccResult, position, constraint);
            item = this.firstItem;
        } else {
            item = item.setNextItem(this.cryptographicCheckResult(ccResult, position, constraint));
        }
        this.cryptographicValidation = this.getCryptographicValidation(ccResult);
        this.cryptographicValidation.setConcernedMaterial(this.token.getId());
        if (!this.isValid((XmlConstraintsConclusion)ccResult)) {
            return item;
        }
        List digestMatchers = this.token.getDigestMatchers();
        if (Utils.isCollectionNotEmpty((Collection)digestMatchers)) {
            for (XmlDigestMatcher digestMatcher : digestMatchers) {
                DigestAlgorithm digestAlgorithm = digestMatcher.getDigestMethod();
                if (digestAlgorithm == null) continue;
                position = ValidationProcessUtils.getDigestMatcherCryptoPosition(digestMatcher);
                DigestCryptographicChecker dac = new DigestCryptographicChecker(this.i18nProvider, digestAlgorithm, this.currentTime, position, constraint);
                XmlCC dacResult = (XmlCC)dac.execute();
                item = item.setNextItem(this.digestAlgorithmCheckResult(digestMatcher, dacResult, position, constraint));
                if (this.isValid((XmlConstraintsConclusion)dacResult)) continue;
                this.cryptographicValidation = this.getCryptographicValidation(dacResult);
                this.cryptographicValidation.setConcernedMaterial(this.getDigestMatcherDescription(digestMatcher, position));
                break;
            }
        }
        return item;
    }

    protected ChainItem<XmlSAV> cryptographicSignedAttributes(ChainItem<XmlSAV> item) {
        if (this.token.isSigningCertificateReferencePresent()) {
            List signingCertificateReferences = this.token.getSigningCertificateReferences();
            for (CertificateRefWrapper certificateRefWrapper : signingCertificateReferences) {
                DigestAlgorithm digestAlgorithm = certificateRefWrapper.getDigestMethod();
                if (digestAlgorithm == null) continue;
                XmlCC dacResult = this.getSigningCertificateDigestCryptographicCheckResult(certificateRefWrapper);
                if (item == null) {
                    this.firstItem = this.signingCertificateRefDigestAlgoCheckResult(certificateRefWrapper, dacResult);
                    item = this.firstItem;
                } else {
                    item = item.setNextItem(this.signingCertificateRefDigestAlgoCheckResult(certificateRefWrapper, dacResult));
                }
                if (this.cryptographicValidation != null && !this.cryptographicValidation.isSecure() || this.isValid((XmlConstraintsConclusion)dacResult)) continue;
                this.cryptographicValidation = this.getCryptographicValidation(dacResult);
                this.cryptographicValidation.setConcernedMaterial(this.getTokenDescription(certificateRefWrapper.getCertificateId(), MessageTag.ACCM_POS_SIG_CERT_REF));
                break;
            }
        }
        return item;
    }

    private ChainItem<XmlSAV> cryptographicCheckResult(XmlCC ccResult, MessageTag position, CryptographicConstraint constraint) {
        return new CryptographicCheckerResultCheck<XmlSAV>(this.i18nProvider, (XmlSAV)this.result, this.currentTime, position, ccResult, (LevelConstraint)constraint);
    }

    private ChainItem<XmlSAV> digestAlgorithmCheckResult(XmlDigestMatcher digestMatcher, XmlCC ccResult, MessageTag position, CryptographicConstraint constraint) {
        return new DigestMatcherCryptographicCheckerResultCheck<XmlSAV>(this.i18nProvider, (XmlSAV)this.result, this.currentTime, position, digestMatcher.getName(), ccResult, (LevelConstraint)constraint);
    }

    private ChainItem<XmlSAV> signingCertificateRefDigestAlgoCheckResult(CertificateRefWrapper certificateRefWrapper, XmlCC ccResult) {
        LevelConstraint constraint = this.validationPolicy.getSigningCertificateDigestAlgorithmConstraint(this.context);
        return new SigningCertificateRefDigestCryptographicCheckerResultCheck<XmlSAV>(this.i18nProvider, (XmlSAV)this.result, this.currentTime, certificateRefWrapper, ccResult, constraint);
    }

    private XmlCC getSigningCertificateDigestCryptographicCheckResult(CertificateRefWrapper certificateRef) {
        CertificateRefWrapper signingCertificateReference = this.token.getSigningCertificateReference();
        SubContext subContext = signingCertificateReference != null && signingCertificateReference.getCertificateId().equals(certificateRef.getCertificateId()) ? SubContext.SIGNING_CERT : SubContext.CA_CERTIFICATE;
        CryptographicConstraint certificateConstraint = this.validationPolicy.getCertificateCryptographicConstraint(this.context, subContext);
        DigestCryptographicChecker dac = new DigestCryptographicChecker(this.i18nProvider, certificateRef.getDigestMethod(), this.currentTime, MessageTag.ACCM_POS_SIG_CERT_REF, certificateConstraint);
        return (XmlCC)dac.execute();
    }

    @Override
    protected void addAdditionalInfo() {
        super.addAdditionalInfo();
        ((XmlSAV)this.result).setCryptographicValidation(this.cryptographicValidation);
    }

    private XmlCryptographicValidation getCryptographicValidation(XmlCC ccResult) {
        XmlCryptographicValidation cryptographicValidation = new XmlCryptographicValidation();
        cryptographicValidation.setAlgorithm(ccResult.getVerifiedAlgorithm());
        cryptographicValidation.setNotAfter(ccResult.getNotAfter());
        cryptographicValidation.setSecure(this.isValid((XmlConstraintsConclusion)ccResult));
        cryptographicValidation.setValidationTime(this.currentTime);
        return cryptographicValidation;
    }

    private String getDigestMatcherDescription(XmlDigestMatcher digestMatcher, MessageTag position) {
        if (Utils.isStringNotEmpty((String)digestMatcher.getName())) {
            return this.i18nProvider.getMessage(MessageTag.ACCM_DESC_WITH_NAME, new Object[]{position, digestMatcher.getName()});
        }
        return this.i18nProvider.getMessage(position, new Object[0]);
    }

    private String getTokenDescription(String id, MessageTag position) {
        return this.i18nProvider.getMessage(MessageTag.ACCM_DESC_WITH_ID, new Object[]{position, id});
    }
}

