/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor.certificate;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlDetailedReport;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.executor.AbstractDetailedReportBuilder;
import eu.europa.esig.dss.validation.process.qualification.certificate.CertificateQualificationBlock;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;

public class DetailedReportForCertificateBuilder
extends AbstractDetailedReportBuilder {
    private final String certificateId;

    public DetailedReportForCertificateBuilder(I18nProvider i18nProvider, DiagnosticData diagnosticData, ValidationPolicy policy, Date currentTime, String certificateId) {
        super(i18nProvider, currentTime, policy, diagnosticData);
        this.certificateId = certificateId;
    }

    XmlDetailedReport build() {
        XmlDetailedReport detailedReport = this.init();
        CertificateWrapper certificate = this.diagnosticData.getUsedCertificateById(this.certificateId);
        if (certificate == null) {
            throw new IllegalArgumentException(String.format("The certificate with the given Id '%s' has not been found in DiagnosticData", this.certificateId));
        }
        HashMap<String, XmlBasicBuildingBlocks> bbbs = new HashMap<String, XmlBasicBuildingBlocks>();
        this.process(Collections.singleton(certificate), Context.CERTIFICATE, bbbs);
        detailedReport.getBasicBuildingBlocks().addAll(bbbs.values());
        XmlBasicBuildingBlocks basicBuildingBlocks = (XmlBasicBuildingBlocks)bbbs.get(certificate.getId());
        CertificateQualificationBlock cqb = new CertificateQualificationBlock(this.i18nProvider, basicBuildingBlocks.getConclusion(), this.currentTime, certificate, detailedReport.getTLAnalysis());
        detailedReport.getSignatureOrTimestampOrCertificate().add(cqb.execute());
        return detailedReport;
    }
}

