/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xml.common.alert;

import eu.europa.esig.dss.alert.AbstractAlert;
import eu.europa.esig.dss.alert.detector.AlertDetector;
import eu.europa.esig.dss.alert.handler.AlertHandler;
import eu.europa.esig.dss.xml.common.DSSErrorHandler;
import eu.europa.esig.dss.xml.common.exception.XSDValidationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;

public class DSSErrorHandlerAlert
extends AbstractAlert<DSSErrorHandler> {
    private static final Logger LOG = LoggerFactory.getLogger(DSSErrorHandlerAlert.class);
    private static final String ERROR_MESSAGE = "Error during the XML schema validation : {}";
    private boolean enableWarnings = false;
    private boolean enablePosition = false;

    public void setEnableWarnings(boolean enableWarnings) {
        this.enableWarnings = enableWarnings;
    }

    public void setEnablePosition(boolean enablePosition) {
        this.enablePosition = enablePosition;
    }

    protected AlertDetector<DSSErrorHandler> getAlertDetector() {
        return errorHandler -> !errorHandler.isValid();
    }

    protected AlertHandler<DSSErrorHandler> getAlertHandler() {
        return new AlertHandler<DSSErrorHandler>(){

            public void process(DSSErrorHandler errorHandler) {
                ArrayList<SAXParseException> exceptions = new ArrayList<SAXParseException>();
                exceptions.addAll(this.getFatalErrors(errorHandler));
                exceptions.addAll(this.getErrors(errorHandler));
                exceptions.addAll(this.getWarnings(errorHandler));
                List<String> messages = this.processExceptions(exceptions);
                XSDValidationException xsdValidationException = new XSDValidationException(messages);
                exceptions.forEach(xsdValidationException::addSuppressed);
                throw xsdValidationException;
            }

            private List<SAXParseException> getFatalErrors(DSSErrorHandler errorHandler) {
                return errorHandler.getFatalErrors();
            }

            private List<SAXParseException> getErrors(DSSErrorHandler errorHandler) {
                return errorHandler.getErrors();
            }

            private List<SAXParseException> getWarnings(DSSErrorHandler errorHandler) {
                if (DSSErrorHandlerAlert.this.enableWarnings) {
                    return errorHandler.getWarnings();
                }
                if (LOG.isDebugEnabled()) {
                    for (SAXParseException warningException : errorHandler.getWarnings()) {
                        LOG.debug(DSSErrorHandlerAlert.this.getValidationMessage(warningException));
                    }
                }
                return Collections.emptyList();
            }

            private List<String> processExceptions(List<SAXParseException> exceptions) {
                ArrayList<String> messages = new ArrayList<String>();
                for (SAXParseException exception : exceptions) {
                    String validationMessage = DSSErrorHandlerAlert.this.getValidationMessage(exception);
                    LOG.warn(DSSErrorHandlerAlert.ERROR_MESSAGE, (Object)validationMessage);
                    messages.add(validationMessage);
                }
                return messages;
            }
        };
    }

    protected String getValidationMessage(SAXParseException e) {
        String message = e.getMessage();
        if (this.enablePosition) {
            message = String.format("%s (Line: %s, Column: %s)", message, e.getLineNumber(), e.getColumnNumber());
        }
        return message;
    }
}

