/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xml.common;

import eu.europa.esig.dss.xml.common.AbstractFactoryBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentBuilderFactoryBuilder
extends AbstractFactoryBuilder<DocumentBuilderFactory> {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentBuilderFactoryBuilder.class);

    protected DocumentBuilderFactoryBuilder() {
        this.enableFeature("http://xml.org/sax/features/namespaces");
        this.enableFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes");
        this.enableFeature("http://apache.org/xml/features/disallow-doctype-decl");
        this.disableFeature("http://xml.org/sax/features/external-general-entities");
        this.disableFeature("http://xml.org/sax/features/external-parameter-entities");
        this.disableFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd");
        this.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        this.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
    }

    public static DocumentBuilderFactoryBuilder getSecureDocumentBuilderFactoryBuilder() {
        return new DocumentBuilderFactoryBuilder();
    }

    public DocumentBuilderFactory build() {
        DocumentBuilderFactory documentBuilderFactory = this.instantiateFactory();
        this.setSecurityFeatures(documentBuilderFactory);
        this.setSecurityAttributes(documentBuilderFactory);
        return documentBuilderFactory;
    }

    @Override
    protected DocumentBuilderFactory instantiateFactory() {
        return DocumentBuilderFactory.newInstance();
    }

    public DocumentBuilderFactoryBuilder enableFeature(String feature) {
        return (DocumentBuilderFactoryBuilder)super.enableFeature(feature);
    }

    public DocumentBuilderFactoryBuilder disableFeature(String feature) {
        return (DocumentBuilderFactoryBuilder)super.disableFeature(feature);
    }

    public DocumentBuilderFactoryBuilder setAttribute(String attribute, Object value) {
        return (DocumentBuilderFactoryBuilder)super.setAttribute(attribute, value);
    }

    public DocumentBuilderFactoryBuilder removeAttribute(String attribute) {
        return (DocumentBuilderFactoryBuilder)super.removeAttribute(attribute);
    }

    @Override
    protected void setSecurityFeature(DocumentBuilderFactory factory, String feature, Boolean value) {
        try {
            factory.setFeature(feature, value);
        }
        catch (ParserConfigurationException e) {
            String message = String.format("SECURITY : unable to set feature '%s' = '%s' (more details in LOG debug)", feature, value);
            if (LOG.isDebugEnabled()) {
                LOG.warn(message, (Throwable)e);
            }
            LOG.warn(message);
        }
    }

    @Override
    protected void setSecurityAttribute(DocumentBuilderFactory factory, String attribute, Object value) {
        try {
            factory.setAttribute(attribute, value);
        }
        catch (IllegalArgumentException e) {
            String message = String.format("SECURITY : unable to set attribute '%s' = '%s' (more details in LOG debug)", attribute, value);
            if (LOG.isDebugEnabled()) {
                LOG.warn(message, (Throwable)e);
            }
            LOG.warn(message);
        }
    }
}

