/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.utils;

import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public abstract class AbstractUtilsTest {
    @TempDir
    Path folder;

    @Test
    public void isStringEmpty() {
        Assertions.assertTrue((boolean)Utils.isStringEmpty((String)""));
        Assertions.assertFalse((boolean)Utils.isStringEmpty((String)"  "));
        Assertions.assertTrue((boolean)Utils.isStringEmpty(null));
        Assertions.assertFalse((boolean)Utils.isStringEmpty((String)"bla"));
    }

    @Test
    public void isStringNotEmpty() {
        Assertions.assertFalse((boolean)Utils.isStringNotEmpty((String)""));
        Assertions.assertTrue((boolean)Utils.isStringNotEmpty((String)"  "));
        Assertions.assertFalse((boolean)Utils.isStringNotEmpty(null));
        Assertions.assertTrue((boolean)Utils.isStringNotEmpty((String)"bla"));
    }

    @Test
    public void areAllStringsEmpty() {
        Object nullString = null;
        Assertions.assertTrue((boolean)Utils.areAllStringsEmpty((String[])new String[]{nullString}));
        Assertions.assertTrue((boolean)Utils.areAllStringsEmpty((String[])new String[]{""}));
        Assertions.assertFalse((boolean)Utils.areAllStringsEmpty((String[])new String[]{"  "}));
        Assertions.assertFalse((boolean)Utils.areAllStringsEmpty((String[])new String[]{"bla"}));
        Assertions.assertTrue((boolean)Utils.areAllStringsEmpty((String[])new String[]{"", nullString}));
        Assertions.assertFalse((boolean)Utils.areAllStringsEmpty((String[])new String[]{"", " "}));
        Assertions.assertFalse((boolean)Utils.areAllStringsEmpty((String[])new String[]{"bla", " "}));
        Assertions.assertTrue((boolean)Utils.areAllStringsEmpty((String[])new String[]{"", "", ""}));
        Assertions.assertTrue((boolean)Utils.areAllStringsEmpty((String[])new String[]{nullString, nullString, nullString}));
        Assertions.assertFalse((boolean)Utils.areAllStringsEmpty((String[])new String[]{"bla", " ", ""}));
        Assertions.assertFalse((boolean)Utils.areAllStringsEmpty((String[])new String[]{"bla", " ", "bla"}));
    }

    @Test
    public void isAtLeastOneStringNotEmpty() {
        Object nullString = null;
        Assertions.assertFalse((boolean)Utils.isAtLeastOneStringNotEmpty((String[])new String[]{nullString}));
        Assertions.assertFalse((boolean)Utils.isAtLeastOneStringNotEmpty((String[])new String[]{""}));
        Assertions.assertTrue((boolean)Utils.isAtLeastOneStringNotEmpty((String[])new String[]{"  "}));
        Assertions.assertTrue((boolean)Utils.isAtLeastOneStringNotEmpty((String[])new String[]{"bla"}));
        Assertions.assertFalse((boolean)Utils.isAtLeastOneStringNotEmpty((String[])new String[]{"", nullString}));
        Assertions.assertTrue((boolean)Utils.isAtLeastOneStringNotEmpty((String[])new String[]{"", " "}));
        Assertions.assertTrue((boolean)Utils.isAtLeastOneStringNotEmpty((String[])new String[]{"bla", " "}));
        Assertions.assertFalse((boolean)Utils.isAtLeastOneStringNotEmpty((String[])new String[]{"", "", ""}));
        Assertions.assertFalse((boolean)Utils.isAtLeastOneStringNotEmpty((String[])new String[]{nullString, nullString, nullString}));
        Assertions.assertTrue((boolean)Utils.isAtLeastOneStringNotEmpty((String[])new String[]{"bla", " ", ""}));
        Assertions.assertTrue((boolean)Utils.isAtLeastOneStringNotEmpty((String[])new String[]{"bla", " ", "bla"}));
    }

    @Test
    public void isStringBlank() {
        Assertions.assertTrue((boolean)Utils.isStringBlank((String)""));
        Assertions.assertTrue((boolean)Utils.isStringBlank((String)"  "));
        Assertions.assertTrue((boolean)Utils.isStringBlank(null));
        Assertions.assertFalse((boolean)Utils.isStringBlank((String)"bla"));
    }

    @Test
    public void isStringNotBlank() {
        Assertions.assertFalse((boolean)Utils.isStringNotBlank((String)""));
        Assertions.assertFalse((boolean)Utils.isStringNotBlank((String)"  "));
        Assertions.assertFalse((boolean)Utils.isStringNotBlank(null));
        Assertions.assertTrue((boolean)Utils.isStringNotBlank((String)"bla"));
    }

    @Test
    public void areStringsEqual() {
        Assertions.assertTrue((boolean)Utils.areStringsEqual(null, null));
        Assertions.assertTrue((boolean)Utils.areStringsEqual((String)"", (String)""));
        Assertions.assertFalse((boolean)Utils.areStringsEqual((String)"", (String)"123"));
        Assertions.assertFalse((boolean)Utils.areStringsEqual((String)"123", (String)"456"));
        Assertions.assertFalse((boolean)Utils.areStringsEqual(null, (String)""));
        Assertions.assertTrue((boolean)Utils.areStringsEqual((String)"bla", (String)"bla"));
        Assertions.assertFalse((boolean)Utils.areStringsEqual((String)"bla", (String)"BLA"));
    }

    @Test
    public void areStringsEqualIgnoreCase() {
        Assertions.assertTrue((boolean)Utils.areStringsEqualIgnoreCase(null, null));
        Assertions.assertTrue((boolean)Utils.areStringsEqualIgnoreCase((String)"", (String)""));
        Assertions.assertFalse((boolean)Utils.areStringsEqualIgnoreCase((String)"", (String)"123"));
        Assertions.assertFalse((boolean)Utils.areStringsEqualIgnoreCase((String)"123", (String)"456"));
        Assertions.assertFalse((boolean)Utils.areStringsEqualIgnoreCase(null, (String)""));
        Assertions.assertTrue((boolean)Utils.areStringsEqualIgnoreCase((String)"bla", (String)"bla"));
        Assertions.assertTrue((boolean)Utils.areStringsEqualIgnoreCase((String)"bla", (String)"BLA"));
    }

    @Test
    public void isStringDigits() {
        Assertions.assertFalse((boolean)Utils.isStringDigits((String)""));
        Assertions.assertFalse((boolean)Utils.isStringDigits(null));
        Assertions.assertFalse((boolean)Utils.isStringDigits((String)"bla"));
        Assertions.assertTrue((boolean)Utils.isStringDigits((String)"123"));
        Assertions.assertFalse((boolean)Utils.isStringDigits((String)"123BLA"));
        Assertions.assertFalse((boolean)Utils.isStringDigits((String)"12 3"));
        Assertions.assertFalse((boolean)Utils.isStringDigits((String)"12-3"));
        Assertions.assertFalse((boolean)Utils.isStringDigits((String)"12.3"));
        Assertions.assertFalse((boolean)Utils.isStringDigits((String)"-123"));
        Assertions.assertFalse((boolean)Utils.isStringDigits((String)"+123"));
    }

    @Test
    public void trim() {
        Assertions.assertNull((Object)Utils.trim(null));
        Assertions.assertEquals((Object)"", (Object)Utils.trim((String)""));
        Assertions.assertEquals((Object)"", (Object)Utils.trim((String)"   "));
        Assertions.assertEquals((Object)"AAA", (Object)Utils.trim((String)" AAA  "));
        Assertions.assertEquals((Object)"AA A", (Object)Utils.trim((String)" AA A  "));
    }

    @Test
    public void joinStrings() {
        Assertions.assertNull((Object)Utils.joinStrings(null, null));
        Assertions.assertEquals((Object)"", (Object)Utils.joinStrings(new ArrayList(), null));
        Assertions.assertEquals((Object)"", (Object)Utils.joinStrings(new ArrayList(), (String)","));
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        list.add("c");
        Assertions.assertEquals((Object)"a,b,c", (Object)Utils.joinStrings(list, (String)","));
        Assertions.assertEquals((Object)"abc", (Object)Utils.joinStrings(list, (String)""));
    }

    @Test
    public void substringAfter() {
        Assertions.assertNull((Object)Utils.substringAfter(null, null));
        Assertions.assertEquals((Object)"", (Object)Utils.substringAfter((String)"", null));
        Assertions.assertEquals((Object)"bbb", (Object)Utils.substringAfter((String)"aaaaa?bbb", (String)"?"));
    }

    @Test
    public void endsWithIgnoreCase() {
        Assertions.assertTrue((boolean)Utils.endsWithIgnoreCase((String)"hello", (String)"lo"));
        Assertions.assertTrue((boolean)Utils.endsWithIgnoreCase((String)"hello", (String)"LO"));
        Assertions.assertFalse((boolean)Utils.endsWithIgnoreCase((String)"hello", null));
        Assertions.assertFalse((boolean)Utils.endsWithIgnoreCase(null, (String)"lo"));
        Assertions.assertFalse((boolean)Utils.endsWithIgnoreCase((String)"hello", (String)"la"));
    }

    @Test
    public void getFileNameExtension() {
        Assertions.assertEquals((Object)"xml", (Object)Utils.getFileNameExtension((String)"file.xml"));
        Assertions.assertEquals((Object)"pdf", (Object)Utils.getFileNameExtension((String)"document.pdf"));
        Assertions.assertEquals((Object)"pdf", (Object)Utils.getFileNameExtension((String)"document..pdf"));
        Assertions.assertEquals((Object)"pdf", (Object)Utils.getFileNameExtension((String)"document.one.pdf"));
        Assertions.assertEquals((Object)"java", (Object)Utils.getFileNameExtension((String)"C:/root/demo.java"));
        Assertions.assertEquals((Object)"java", (Object)Utils.getFileNameExtension((String)"http://nowina.lu/demo.java"));
        Assertions.assertEquals((Object)"", (Object)Utils.getFileNameExtension((String)"document"));
        Assertions.assertEquals((Object)"", (Object)Utils.getFileNameExtension((String)"    "));
        Assertions.assertEquals((Object)"", (Object)Utils.getFileNameExtension((String)""));
        Assertions.assertNull((Object)Utils.getFileNameExtension(null));
    }

    @Test
    public void lowerCase() {
        Assertions.assertNull((Object)Utils.lowerCase(null));
        Assertions.assertEquals((Object)"", (Object)Utils.lowerCase((String)""));
        Assertions.assertEquals((Object)" ", (Object)Utils.lowerCase((String)" "));
        Assertions.assertEquals((Object)"aaaa", (Object)Utils.lowerCase((String)"AaAa"));
        Assertions.assertEquals((Object)"aaaa-_&", (Object)Utils.lowerCase((String)"AaAa-_&"));
    }

    @Test
    public void upperCase() {
        Assertions.assertNull((Object)Utils.upperCase(null));
        Assertions.assertEquals((Object)"", (Object)Utils.upperCase((String)""));
        Assertions.assertEquals((Object)" ", (Object)Utils.upperCase((String)" "));
        Assertions.assertEquals((Object)"AAAA", (Object)Utils.upperCase((String)"AaAa"));
        Assertions.assertEquals((Object)"AAAA-_&", (Object)Utils.upperCase((String)"AaAa-_&"));
    }

    @Test
    public void isArrayEmptyObj() {
        Assertions.assertTrue((boolean)Utils.isArrayEmpty((Object[])null));
        Assertions.assertTrue((boolean)Utils.isArrayEmpty((Object[])new Object[0]));
        Assertions.assertFalse((boolean)Utils.isArrayEmpty((Object[])new Object[]{null}));
        Assertions.assertFalse((boolean)Utils.isArrayEmpty((Object[])new Object[]{"1", 1}));
    }

    @Test
    public void isArrayNotEmptyObj() {
        Assertions.assertFalse((boolean)Utils.isArrayNotEmpty((Object[])null));
        Assertions.assertFalse((boolean)Utils.isArrayNotEmpty((Object[])new Object[0]));
        Assertions.assertTrue((boolean)Utils.isArrayNotEmpty((Object[])new Object[]{null}));
        Assertions.assertTrue((boolean)Utils.isArrayNotEmpty((Object[])new Object[]{"1", 1}));
    }

    @Test
    public void isArrayEmpty() {
        Assertions.assertTrue((boolean)Utils.isArrayEmpty((byte[])null));
        Assertions.assertTrue((boolean)Utils.isArrayEmpty((byte[])new byte[0]));
        Assertions.assertFalse((boolean)Utils.isArrayEmpty((byte[])new byte[]{1}));
    }

    @Test
    public void isArrayNotEmpty() {
        Assertions.assertFalse((boolean)Utils.isArrayNotEmpty((byte[])null));
        Assertions.assertFalse((boolean)Utils.isArrayNotEmpty((byte[])new byte[0]));
        Assertions.assertTrue((boolean)Utils.isArrayNotEmpty((byte[])new byte[]{1}));
    }

    @Test
    public void isArrayEmptyChar() {
        Assertions.assertTrue((boolean)Utils.isArrayEmpty((char[])null));
        Assertions.assertTrue((boolean)Utils.isArrayEmpty((char[])new char[0]));
        Assertions.assertFalse((boolean)Utils.isArrayEmpty((char[])new char[]{' '}));
        Assertions.assertFalse((boolean)Utils.isArrayEmpty((char[])new char[]{'A'}));
        Assertions.assertFalse((boolean)Utils.isArrayEmpty((char[])new char[]{'A', 'A', 'A', 'A'}));
        Assertions.assertFalse((boolean)Utils.isArrayEmpty((char[])new char[]{'A', 'B', 'C', 'D'}));
    }

    @Test
    public void isArrayNotEmptyChar() {
        Assertions.assertFalse((boolean)Utils.isArrayNotEmpty((char[])null));
        Assertions.assertFalse((boolean)Utils.isArrayNotEmpty((char[])new char[0]));
        Assertions.assertTrue((boolean)Utils.isArrayNotEmpty((char[])new char[]{' '}));
        Assertions.assertTrue((boolean)Utils.isArrayNotEmpty((char[])new char[]{'A'}));
        Assertions.assertTrue((boolean)Utils.isArrayNotEmpty((char[])new char[]{'A', 'A', 'A', 'A'}));
        Assertions.assertTrue((boolean)Utils.isArrayNotEmpty((char[])new char[]{'A', 'B', 'C', 'D'}));
    }

    @Test
    public void subarray() {
        byte[] array = new byte[]{1, 2, 3, 4, 5};
        Assertions.assertArrayEquals((byte[])array, (byte[])Utils.subarray((byte[])array, (int)0, (int)array.length));
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3}, (byte[])Utils.subarray((byte[])array, (int)0, (int)3));
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])Utils.subarray((byte[])array, (int)0, (int)0));
        Assertions.assertArrayEquals(null, (byte[])Utils.subarray(null, (int)0, (int)0));
    }

    @Test
    public void isTrue() {
        Assertions.assertFalse((boolean)Utils.isTrue(null));
        Assertions.assertFalse((boolean)Utils.isTrue((Boolean)false));
        Assertions.assertTrue((boolean)Utils.isTrue((Boolean)true));
        Assertions.assertTrue((boolean)Utils.isTrue((Boolean)Boolean.TRUE));
    }

    @Test
    public void isCollectionEmpty() {
        Assertions.assertTrue((boolean)Utils.isCollectionEmpty(null));
        Assertions.assertTrue((boolean)Utils.isCollectionEmpty(new ArrayList()));
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        list.add("c");
        Assertions.assertFalse((boolean)Utils.isCollectionEmpty(list));
    }

    @Test
    public void isCollectionNotEmpty() {
        Assertions.assertFalse((boolean)Utils.isCollectionNotEmpty(null));
        Assertions.assertFalse((boolean)Utils.isCollectionNotEmpty(new ArrayList()));
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        list.add("c");
        Assertions.assertTrue((boolean)Utils.isCollectionNotEmpty(list));
    }

    @Test
    public void isMapEmpty() {
        Assertions.assertTrue((boolean)Utils.isMapEmpty(null));
        Assertions.assertTrue((boolean)Utils.isMapEmpty(new HashMap()));
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("a", true);
        map.put("b", false);
        map.put("c", true);
        Assertions.assertFalse((boolean)Utils.isMapEmpty(map));
        Assertions.assertEquals((int)3, (int)map.size());
        map.clear();
        Assertions.assertTrue((boolean)Utils.isMapEmpty(map));
    }

    @Test
    public void isMapNotEmpty() {
        Assertions.assertFalse((boolean)Utils.isMapNotEmpty(null));
        Assertions.assertFalse((boolean)Utils.isMapNotEmpty(new HashMap()));
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("a", true);
        map.put("b", false);
        map.put("c", true);
        Assertions.assertTrue((boolean)Utils.isMapNotEmpty(map));
        Assertions.assertEquals((int)3, (int)map.size());
        map.clear();
        Assertions.assertFalse((boolean)Utils.isMapNotEmpty(map));
    }

    @Test
    public void collectionSize() {
        Assertions.assertEquals((int)0, (int)Utils.collectionSize(null));
        Assertions.assertEquals((int)0, (int)Utils.collectionSize(new ArrayList()));
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        list.add("c");
        Assertions.assertEquals((int)3, (int)Utils.collectionSize(list));
    }

    @Test
    public void isHexEncodedTest() {
        Assertions.assertTrue((boolean)Utils.isHexEncoded((String)""));
        Assertions.assertTrue((boolean)Utils.isHexEncoded((String)"5361736861"));
        Assertions.assertTrue((boolean)Utils.isHexEncoded((String)"30187F47A8D9AE9D3D12942CE996C3BF746E4F4F"));
        Assertions.assertTrue((boolean)Utils.isHexEncoded((String)"7761726774655c657761723435684e554948672a264833345033"));
        Assertions.assertFalse((boolean)Utils.isHexEncoded((String)"\n536 1736 \n861"));
        Assertions.assertFalse((boolean)Utils.isHexEncoded((String)"5361736861=="));
        Assertions.assertFalse((boolean)Utils.isHexEncoded((String)"AQIDBAU"));
        Assertions.assertFalse((boolean)Utils.isHexEncoded((String)"AQIDBAU=="));
        Assertions.assertFalse((boolean)Utils.isHexEncoded((String)"1.3.5"));
        Assertions.assertFalse((boolean)Utils.isHexEncoded((String)"AS.DF,GH/JK"));
        Assertions.assertThrows(NullPointerException.class, () -> Utils.isHexEncoded(null));
    }

    @Test
    public void toHexNull() {
        Assertions.assertThrows(NullPointerException.class, () -> Utils.toHex(null));
    }

    @Test
    public void toHex() {
        Assertions.assertEquals((Object)"", (Object)Utils.toHex((byte[])new byte[0]));
        Assertions.assertEquals((Object)"0102030405", (Object)Utils.toHex((byte[])new byte[]{1, 2, 3, 4, 5}));
        Assertions.assertEquals((Object)"61027a6a09", (Object)Utils.toHex((byte[])new byte[]{97, 2, 122, 106, 9}));
    }

    @Test
    public void fromHex() {
        Assertions.assertNotNull((Object)Utils.fromHex((String)""));
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4, 5}, (byte[])Utils.fromHex((String)"0102030405"));
        Assertions.assertArrayEquals((byte[])new byte[]{97, 2, 122, 106, 9}, (byte[])Utils.fromHex((String)"61027a6a09"));
        Assertions.assertArrayEquals((byte[])new byte[]{97, 2, 122, 106, 9}, (byte[])Utils.fromHex((String)"61027A6A09"));
    }

    @Test
    public void fromHexNull() {
        Assertions.assertThrows(NullPointerException.class, () -> Utils.fromHex(null));
    }

    @Test
    public void isBase64Encoded() {
        Assertions.assertTrue((boolean)Utils.isBase64Encoded((String)""));
        Assertions.assertTrue((boolean)Utils.isBase64Encoded((String)"AQIDBAU="));
        Assertions.assertTrue((boolean)Utils.isBase64Encoded((String)"AQIDBAU"));
        Assertions.assertTrue((boolean)Utils.isBase64Encoded((String)"AQIDBAU=="));
        Assertions.assertTrue((boolean)Utils.isBase64Encoded((String)"AQIDBAU==="));
        Assertions.assertTrue((boolean)Utils.isBase64Encoded((String)"\nAQI\nD BA\tU=\n"));
        Assertions.assertFalse((boolean)Utils.isBase64Encoded((String)"1.3.5"));
        Assertions.assertFalse((boolean)Utils.isBase64Encoded((String)"AS.DF,GH/JK"));
        Assertions.assertThrows(NullPointerException.class, () -> Utils.isBase64Encoded(null));
    }

    @Test
    public void isBase64EncodedNullPointer() {
        Assertions.assertThrows(NullPointerException.class, () -> Utils.isBase64Encoded(null));
    }

    @Test
    public void toBase64() {
        Assertions.assertEquals((Object)"", (Object)Utils.toBase64((byte[])new byte[0]));
        Assertions.assertEquals((Object)"AQIDBAU=", (Object)Utils.toBase64((byte[])new byte[]{1, 2, 3, 4, 5}));
    }

    @Test
    public void fromBase64() {
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4, 5}, (byte[])Utils.fromBase64((String)"AQIDBAU="));
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4, 5}, (byte[])Utils.fromBase64((String)"\nAQI\nD BA\tU=\n"));
    }

    @Test
    public void toByteArray() throws IOException {
        File newFile = new File("target/sample.txt");
        String newFileContent = "Hello world!";
        FileOutputStream fos = new FileOutputStream(newFile);
        fos.write(newFileContent.getBytes(StandardCharsets.UTF_8));
        fos.close();
        FileInputStream fis = new FileInputStream(newFile);
        Assertions.assertArrayEquals((byte[])newFileContent.getBytes(StandardCharsets.UTF_8), (byte[])Utils.toByteArray((InputStream)fis));
        fis.close();
        Assertions.assertTrue((boolean)newFile.exists());
        Assertions.assertTrue((boolean)newFile.delete());
        Assertions.assertFalse((boolean)newFile.exists());
    }

    @Test
    public void toByteArrayCRLForLF() throws IOException, NoSuchAlgorithmException {
        byte[] byteArray;
        try (InputStream is = AbstractUtilsTest.class.getResourceAsStream("/sample-lf.xml");){
            byteArray = Utils.toByteArray((InputStream)is);
            Assertions.assertEquals((Object)"68ArneI9PhOBJytj5sP/zEewR2DkFObxewMY1wiUvak=", (Object)Utils.toBase64((byte[])MessageDigest.getInstance("SHA-256").digest(byteArray)));
        }
        is = AbstractUtilsTest.class.getResourceAsStream("/sample-cr-lf.xml");
        try {
            byteArray = Utils.toByteArray((InputStream)is);
            Assertions.assertEquals((Object)"kcDHOZjwZhVfuDhuhCeCERRmYpTH4Jj4RmfVVi31Q9g=", (Object)Utils.toBase64((byte[])MessageDigest.getInstance("SHA-256").digest(byteArray)));
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    @Test
    public void closeQuietly() throws IOException {
        Utils.closeQuietly(null);
        File newFile = new File("target/sample2.txt");
        String newFileContent = "Hello world!";
        FileOutputStream fos = new FileOutputStream(newFile);
        fos.write(newFileContent.getBytes(StandardCharsets.UTF_8));
        fos.close();
        Assertions.assertTrue((boolean)newFile.exists());
        Utils.closeQuietly((Closeable)Files.newInputStream(newFile.toPath(), new OpenOption[0]));
        Assertions.assertTrue((boolean)newFile.exists());
        Assertions.assertTrue((boolean)newFile.delete(), (String)"Cannot delete the file");
        Assertions.assertFalse((boolean)newFile.exists());
        FileOutputStream sampleFos = new FileOutputStream("target/sample3.txt");
        Utils.closeQuietly((Closeable)sampleFos);
        Utils.closeQuietly((Closeable)sampleFos);
        File sample = new File("target/sample3.txt");
        Assertions.assertTrue((boolean)sample.exists());
        Assertions.assertTrue((boolean)sample.delete(), (String)"Cannot delete the file");
        Assertions.assertFalse((boolean)sample.exists());
    }

    @Test
    public void listFiles() {
        File folder = new File("src/main/java");
        String[] extensions = new String[]{"java"};
        Collection listFiles = Utils.listFiles((File)folder, (String[])extensions, (boolean)true);
        Assertions.assertTrue((boolean)Utils.isCollectionNotEmpty((Collection)listFiles));
        extensions = new String[]{"doc", "pdf"};
        listFiles = Utils.listFiles((File)folder, (String[])extensions, (boolean)true);
        Assertions.assertTrue((boolean)Utils.isCollectionEmpty((Collection)listFiles));
    }

    @Test
    public void getInputStreamSize() throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream("Hello World!".getBytes());){
            Assertions.assertEquals((long)12L, (long)Utils.getInputStreamSize((InputStream)is));
        }
        try (ByteArrayInputStream emptyIs = new ByteArrayInputStream(new byte[0]);){
            Assertions.assertEquals((long)0L, (long)Utils.getInputStreamSize((InputStream)emptyIs));
        }
        File newFile = new File("target/sample.txt");
        String newFileContent = "Hello world!\r\n";
        try (FileOutputStream fos = new FileOutputStream(newFile);){
            fos.write(newFileContent.getBytes(StandardCharsets.UTF_8));
        }
        try (FileInputStream fileInputStream = new FileInputStream(newFile);){
            Assertions.assertEquals((long)14L, (long)Utils.getInputStreamSize((InputStream)fileInputStream));
        }
        Assertions.assertTrue((boolean)newFile.exists());
        Assertions.assertTrue((boolean)newFile.delete());
        Assertions.assertFalse((boolean)newFile.exists());
    }

    @Test
    public void compareInputStreams() throws IOException {
        ByteArrayInputStream is2;
        FileInputStream fis2;
        ByteArrayInputStream is22;
        String content = "Hello world!";
        String contentTwo = "Bye world!";
        try (ByteArrayInputStream is1 = new ByteArrayInputStream(content.getBytes());){
            Assertions.assertTrue((boolean)Utils.compareInputStreams((InputStream)is1, (InputStream)is1));
        }
        is1 = new ByteArrayInputStream(content.getBytes());
        try {
            is22 = new ByteArrayInputStream(content.getBytes());
            try {
                Assertions.assertTrue((boolean)Utils.compareInputStreams((InputStream)is1, (InputStream)is22));
            }
            finally {
                ((InputStream)is22).close();
            }
        }
        finally {
            ((InputStream)is1).close();
        }
        is1 = new ByteArrayInputStream(contentTwo.getBytes());
        try {
            is22 = new ByteArrayInputStream(contentTwo.getBytes());
            try {
                Assertions.assertTrue((boolean)Utils.compareInputStreams((InputStream)is1, (InputStream)is22));
            }
            finally {
                ((InputStream)is22).close();
            }
        }
        finally {
            ((InputStream)is1).close();
        }
        is1 = new ByteArrayInputStream(new byte[0]);
        try {
            is22 = new ByteArrayInputStream(new byte[0]);
            try {
                Assertions.assertTrue((boolean)Utils.compareInputStreams((InputStream)is1, (InputStream)is22));
            }
            finally {
                ((InputStream)is22).close();
            }
        }
        finally {
            ((InputStream)is1).close();
        }
        is1 = new ByteArrayInputStream(content.getBytes());
        try {
            is22 = new ByteArrayInputStream(new byte[0]);
            try {
                Assertions.assertFalse((boolean)Utils.compareInputStreams((InputStream)is1, (InputStream)is22));
            }
            finally {
                ((InputStream)is22).close();
            }
        }
        finally {
            ((InputStream)is1).close();
        }
        is1 = new ByteArrayInputStream(content.getBytes());
        try {
            is22 = new ByteArrayInputStream(new byte[0]);
            try {
                Assertions.assertFalse((boolean)Utils.compareInputStreams((InputStream)is22, (InputStream)is1));
            }
            finally {
                ((InputStream)is22).close();
            }
        }
        finally {
            ((InputStream)is1).close();
        }
        is1 = new ByteArrayInputStream(content.getBytes());
        try {
            is22 = new ByteArrayInputStream(contentTwo.getBytes());
            try {
                Assertions.assertFalse((boolean)Utils.compareInputStreams((InputStream)is1, (InputStream)is22));
            }
            finally {
                ((InputStream)is22).close();
            }
        }
        finally {
            ((InputStream)is1).close();
        }
        is1 = new ByteArrayInputStream(content.getBytes());
        try {
            is22 = new ByteArrayInputStream(contentTwo.getBytes());
            try {
                Assertions.assertFalse((boolean)Utils.compareInputStreams((InputStream)is22, (InputStream)is1));
            }
            finally {
                ((InputStream)is22).close();
            }
        }
        finally {
            ((InputStream)is1).close();
        }
        is1 = null;
        try {
            is22 = null;
            try {
                Assertions.assertTrue((boolean)Utils.compareInputStreams((InputStream)is1, (InputStream)is22));
            }
            finally {
                if (is22 != null) {
                    ((InputStream)is22).close();
                }
            }
        }
        finally {
            if (is1 != null) {
                ((InputStream)is1).close();
            }
        }
        is1 = new ByteArrayInputStream(content.getBytes());
        try {
            is22 = null;
            try {
                Assertions.assertFalse((boolean)Utils.compareInputStreams((InputStream)is1, (InputStream)is22));
            }
            finally {
                if (is22 != null) {
                    ((InputStream)is22).close();
                }
            }
        }
        finally {
            ((InputStream)is1).close();
        }
        is1 = new ByteArrayInputStream(content.getBytes());
        try {
            is22 = null;
            try {
                Assertions.assertFalse((boolean)Utils.compareInputStreams((InputStream)is22, (InputStream)is1));
            }
            finally {
                if (is22 != null) {
                    ((InputStream)is22).close();
                }
            }
        }
        finally {
            ((InputStream)is1).close();
        }
        File newFileOne = new File("target/sample.txt");
        File newFileTwo = new File("target/sampleTwo.txt");
        try (FileOutputStream fos = new FileOutputStream(newFileOne);){
            fos.write(content.getBytes(StandardCharsets.UTF_8));
        }
        Assertions.assertTrue((boolean)newFileOne.exists());
        fos = new FileOutputStream(newFileTwo);
        try {
            fos.write(contentTwo.getBytes(StandardCharsets.UTF_8));
        }
        finally {
            fos.close();
        }
        Assertions.assertTrue((boolean)newFileTwo.exists());
        try (FileInputStream fis1 = new FileInputStream(newFileOne);){
            Assertions.assertTrue((boolean)Utils.compareInputStreams((InputStream)fis1, (InputStream)fis1));
        }
        fis1 = new FileInputStream(newFileOne);
        try {
            fis2 = new FileInputStream(newFileOne);
            try {
                Assertions.assertTrue((boolean)Utils.compareInputStreams((InputStream)fis1, (InputStream)fis2));
            }
            finally {
                fis2.close();
            }
        }
        finally {
            fis1.close();
        }
        fis1 = new FileInputStream(newFileOne);
        try {
            fis2 = new FileInputStream(newFileTwo);
            try {
                Assertions.assertFalse((boolean)Utils.compareInputStreams((InputStream)fis1, (InputStream)fis2));
            }
            finally {
                fis2.close();
            }
        }
        finally {
            fis1.close();
        }
        fis1 = new FileInputStream(newFileOne);
        try {
            fis2 = new FileInputStream(newFileTwo);
            try {
                Assertions.assertFalse((boolean)Utils.compareInputStreams((InputStream)fis2, (InputStream)fis1));
            }
            finally {
                fis2.close();
            }
        }
        finally {
            fis1.close();
        }
        fis1 = new FileInputStream(newFileOne);
        try {
            is2 = new ByteArrayInputStream(content.getBytes());
            try {
                Assertions.assertTrue((boolean)Utils.compareInputStreams((InputStream)fis1, (InputStream)is2));
            }
            finally {
                ((InputStream)is2).close();
            }
        }
        finally {
            fis1.close();
        }
        fis1 = new FileInputStream(newFileOne);
        try {
            is2 = new ByteArrayInputStream(content.getBytes());
            try {
                Assertions.assertTrue((boolean)Utils.compareInputStreams((InputStream)is2, (InputStream)fis1));
            }
            finally {
                ((InputStream)is2).close();
            }
        }
        finally {
            fis1.close();
        }
        fis1 = new FileInputStream(newFileOne);
        try {
            is2 = new ByteArrayInputStream(contentTwo.getBytes());
            try {
                Assertions.assertFalse((boolean)Utils.compareInputStreams((InputStream)fis1, (InputStream)is2));
            }
            finally {
                ((InputStream)is2).close();
            }
        }
        finally {
            fis1.close();
        }
        fis1 = new FileInputStream(newFileOne);
        try {
            is2 = new ByteArrayInputStream(contentTwo.getBytes());
            try {
                Assertions.assertFalse((boolean)Utils.compareInputStreams((InputStream)is2, (InputStream)fis1));
            }
            finally {
                ((InputStream)is2).close();
            }
        }
        finally {
            fis1.close();
        }
        fis1 = new FileInputStream(newFileTwo);
        try {
            is2 = new ByteArrayInputStream(contentTwo.getBytes());
            try {
                Assertions.assertTrue((boolean)Utils.compareInputStreams((InputStream)fis1, (InputStream)is2));
            }
            finally {
                ((InputStream)is2).close();
            }
        }
        finally {
            fis1.close();
        }
        fis1 = new FileInputStream(newFileTwo);
        try {
            is2 = new ByteArrayInputStream(contentTwo.getBytes());
            try {
                Assertions.assertTrue((boolean)Utils.compareInputStreams((InputStream)is2, (InputStream)fis1));
            }
            finally {
                ((InputStream)is2).close();
            }
        }
        finally {
            fis1.close();
        }
        Assertions.assertTrue((boolean)newFileOne.delete());
        Assertions.assertTrue((boolean)newFileTwo.delete());
        Assertions.assertFalse((boolean)newFileOne.exists());
        Assertions.assertFalse((boolean)newFileTwo.exists());
    }

    @Test
    public void clearDirectory() throws IOException {
        Path pathToFolder = this.folder.resolve("test");
        File dir = new File(pathToFolder.toString());
        Assertions.assertTrue((boolean)dir.mkdir());
        Utils.cleanDirectory((File)dir);
        Assertions.assertTrue((boolean)dir.exists());
        String[] list = dir.list();
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)0, (int)list.length);
        Assertions.assertTrue((boolean)dir.delete(), (String)"Cannot delete the directory");
        Assertions.assertFalse((boolean)dir.exists());
    }

    @Test
    public void clearDirectoryNotFound() throws FileNotFoundException {
        Assertions.assertThrows(FileNotFoundException.class, () -> Utils.cleanDirectory((File)new File("wrong")));
    }

    @Test
    public void reverseListTest() {
        List<String> stringsList = Arrays.asList("a", "b", "c");
        Assertions.assertEquals(Arrays.asList("c", "b", "a"), (Object)Utils.reverseList(stringsList));
        List<Integer> intList = Arrays.asList(1, 2, 3, null);
        Assertions.assertEquals(Arrays.asList(null, 3, 2, 1), (Object)Utils.reverseList(intList));
        List emptyList = Collections.emptyList();
        Assertions.assertEquals((int)0, (int)Utils.reverseList(emptyList).size());
        Assertions.assertThrows(Exception.class, () -> Utils.reverseList(null));
    }

    @Test
    public void containsAnyTest() {
        Assertions.assertTrue((boolean)Utils.containsAny(Arrays.asList("c", "b", "a"), Arrays.asList("c", "b", "a")));
        Assertions.assertTrue((boolean)Utils.containsAny(Arrays.asList("c", "b", "a"), Arrays.asList("a")));
        Assertions.assertTrue((boolean)Utils.containsAny(Arrays.asList("c", "b", "a"), Arrays.asList("d", "c", "b", "a")));
        Assertions.assertTrue((boolean)Utils.containsAny(Arrays.asList("c", "b", "a"), Arrays.asList("d", "a")));
        Assertions.assertTrue((boolean)Utils.containsAny(Arrays.asList("c", "b", "a", "a"), Arrays.asList("d", "a")));
        Assertions.assertTrue((boolean)Utils.containsAny(Arrays.asList("c", "b", "a"), Arrays.asList("d", "a", "a")));
        Assertions.assertTrue((boolean)Utils.containsAny(Arrays.asList("c", "b", "a"), Arrays.asList("d", "d", "a")));
        Assertions.assertTrue((boolean)Utils.containsAny(Arrays.asList("c", "b", "a", 10), Arrays.asList("a")));
        Assertions.assertTrue((boolean)Utils.containsAny(Arrays.asList("c", "b", "a"), Arrays.asList("a", 10)));
        Assertions.assertTrue((boolean)Utils.containsAny(new HashSet<String>(Arrays.asList("c", "b", "a")), new HashSet<String>(Arrays.asList("c", "b", "a"))));
        Assertions.assertTrue((boolean)Utils.containsAny(new HashSet<String>(Arrays.asList("c", "b", "a")), new HashSet<String>(Arrays.asList("a"))));
        Assertions.assertTrue((boolean)Utils.containsAny(new HashSet<String>(Arrays.asList("c", "b", "a")), new HashSet<String>(Arrays.asList("d", "c", "b", "a"))));
        Assertions.assertTrue((boolean)Utils.containsAny(new HashSet<String>(Arrays.asList("c", "b", "a")), new HashSet<String>(Arrays.asList("d", "a"))));
        Assertions.assertTrue((boolean)Utils.containsAny(Arrays.asList("c", "b", "a"), new HashSet<String>(Arrays.asList("c", "b", "a"))));
        Assertions.assertTrue((boolean)Utils.containsAny(Arrays.asList("c", "b", "a"), Arrays.asList("a")));
        Assertions.assertTrue((boolean)Utils.containsAny(new HashSet<String>(Arrays.asList("c", "b", "a")), Arrays.asList("d", "c", "b", "a")));
        Assertions.assertTrue((boolean)Utils.containsAny(new HashSet<String>(Arrays.asList("c", "b", "a")), Arrays.asList("d", "a")));
        Assertions.assertTrue((boolean)Utils.containsAny(new HashSet<Serializable>(Arrays.asList("c", "b", "a", 1)), Arrays.asList("d", 1)));
        Assertions.assertFalse((boolean)Utils.containsAny(Arrays.asList("c", "b", "a"), Arrays.asList("d", "e", "f")));
        Assertions.assertFalse((boolean)Utils.containsAny(new HashSet<String>(Arrays.asList("c", "b", "a")), new HashSet<String>(Arrays.asList("d", "e", "f"))));
        Assertions.assertFalse((boolean)Utils.containsAny(Arrays.asList("c", "b", "a"), new HashSet<String>(Arrays.asList("d", "e", "f"))));
        Assertions.assertFalse((boolean)Utils.containsAny(new HashSet<String>(Arrays.asList("c", "b", "a")), Arrays.asList("d", "e", "f")));
        Assertions.assertFalse((boolean)Utils.containsAny(Arrays.asList(new String[0]), Arrays.asList("d", "e", "f")));
        Assertions.assertFalse((boolean)Utils.containsAny(Arrays.asList("c", "b", "a"), Arrays.asList(new String[0])));
        Assertions.assertThrows(Exception.class, () -> Utils.containsAny(null, Arrays.asList("c", "b", "a")));
        Assertions.assertThrows(Exception.class, () -> Utils.containsAny(Arrays.asList("c", "b", "a"), null));
        Assertions.assertThrows(Exception.class, () -> Utils.containsAny(null, null));
    }
}

