/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.model.BLevelParameters;
import eu.europa.esig.dss.model.SignatureParametersBuilder;
import eu.europa.esig.dss.model.x509.CertificateToken;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractSignatureParametersBuilder<SP extends AbstractSignatureParameters>
implements SignatureParametersBuilder<SP> {
    private final CertificateToken signingCertificate;
    private List<CertificateToken> certificateChain;
    private EncryptionAlgorithm encryptionAlgorithm;
    private DigestAlgorithm digestAlgorithm;
    private MaskGenerationFunction maskGenerationFunction;
    private BLevelParameters bLevelParams = new BLevelParameters();

    protected AbstractSignatureParametersBuilder(CertificateToken signingCertificate) {
        this(signingCertificate, new LinkedList<CertificateToken>());
    }

    protected AbstractSignatureParametersBuilder(CertificateToken signingCertificate, List<CertificateToken> certificateChain) {
        this.signingCertificate = signingCertificate;
        this.certificateChain = certificateChain;
    }

    protected abstract SP initParameters();

    public AbstractSignatureParametersBuilder setEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        return this;
    }

    public AbstractSignatureParametersBuilder setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
        return this;
    }

    public AbstractSignatureParametersBuilder setMaskGenerationFunction(MaskGenerationFunction maskGenerationFunction) {
        this.maskGenerationFunction = maskGenerationFunction;
        return this;
    }

    public BLevelParameters bLevel() {
        return this.bLevelParams;
    }

    public AbstractSignatureParametersBuilder<SP> setBLevelParams(BLevelParameters bLevelParams) {
        this.bLevelParams = bLevelParams;
        return this;
    }

    public SP build() {
        SP signatureParameters = this.initParameters();
        ((AbstractSignatureParameters)((Object)signatureParameters)).setSigningCertificate(this.signingCertificate);
        ((AbstractSignatureParameters)((Object)signatureParameters)).setCertificateChain(this.certificateChain);
        signatureParameters.setBLevelParams(this.bLevelParams);
        if (this.encryptionAlgorithm != null) {
            signatureParameters.setEncryptionAlgorithm(this.encryptionAlgorithm);
        }
        if (this.digestAlgorithm != null) {
            signatureParameters.setDigestAlgorithm(this.digestAlgorithm);
        }
        if (this.maskGenerationFunction != null) {
            signatureParameters.setMaskGenerationFunction(this.maskGenerationFunction);
        }
        return signatureParameters;
    }
}

