/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.policy;

import eu.europa.esig.dss.validation.SignaturePolicy;
import eu.europa.esig.dss.validation.policy.BasicASNSignaturePolicyValidator;
import eu.europa.esig.dss.validation.policy.SignaturePolicyValidator;
import eu.europa.esig.dss.validation.policy.SignaturePolicyValidatorLoader;
import java.util.Iterator;
import java.util.ServiceLoader;

public class DefaultSignaturePolicyValidatorLoader
implements SignaturePolicyValidatorLoader {
    private SignaturePolicyValidator defaultSignaturePolicyValidator;

    public void setDefaultSignaturePolicyValidator(SignaturePolicyValidator defaultSignaturePolicyValidator) {
        this.defaultSignaturePolicyValidator = defaultSignaturePolicyValidator;
    }

    @Override
    public SignaturePolicyValidator loadValidator(SignaturePolicy signaturePolicy) {
        SignaturePolicyValidator validator = null;
        if (this.defaultSignaturePolicyValidator != null && !signaturePolicy.isHashAsInTechnicalSpecification()) {
            validator = this.defaultSignaturePolicyValidator;
        } else {
            ServiceLoader<SignaturePolicyValidator> loader = ServiceLoader.load(SignaturePolicyValidator.class);
            Iterator<SignaturePolicyValidator> validatorOptions = loader.iterator();
            if (validatorOptions.hasNext()) {
                for (SignaturePolicyValidator signaturePolicyValidator : loader) {
                    if (!signaturePolicyValidator.canValidate(signaturePolicy)) continue;
                    validator = signaturePolicyValidator;
                    break;
                }
            }
            if (validator == null) {
                validator = new BasicASNSignaturePolicyValidator();
            }
        }
        return validator;
    }
}

