/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.value.DataFormatValue;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.w3c.dom.css.CSSValue;
import uk.co.spudsoft.birt.emitters.excel.BirtStyle;
import uk.co.spudsoft.birt.emitters.excel.FontManager;
import uk.co.spudsoft.birt.emitters.excel.StyleManagerUtils;
import uk.co.spudsoft.birt.emitters.excel.StyleManagerXUtils;
import uk.co.spudsoft.birt.emitters.excel.framework.Logger;

public class StyleManager {
    private Workbook workbook;
    private FontManager fm;
    private List<StylePair> styles = new ArrayList<StylePair>();
    private StyleManagerUtils smu;
    private CSSEngine cssEngine;
    private Locale locale;
    static int[] COMPARE_CSS_PROPERTIES;

    static {
        int[] nArray = new int[28];
        nArray[0] = 39;
        nArray[1] = 40;
        nArray[2] = 49;
        nArray[3] = 27;
        nArray[4] = 24;
        nArray[5] = 58;
        nArray[6] = 50;
        nArray[7] = 47;
        nArray[8] = 20;
        nArray[9] = 9;
        nArray[10] = 4;
        nArray[11] = 21;
        nArray[12] = 10;
        nArray[13] = 5;
        nArray[14] = 8;
        nArray[15] = 22;
        nArray[16] = 11;
        nArray[17] = 7;
        nArray[18] = 15;
        nArray[19] = 26;
        nArray[20] = 18;
        nArray[21] = 14;
        nArray[22] = 57;
        nArray[23] = 43;
        nArray[25] = 1;
        nArray[26] = 12;
        nArray[27] = 16;
        COMPARE_CSS_PROPERTIES = nArray;
    }

    public StyleManager(Workbook workbook, Logger log, StyleManagerUtils smu, CSSEngine cssEngine, Locale locale) {
        this.workbook = workbook;
        this.fm = new FontManager(cssEngine, workbook, smu);
        this.smu = smu;
        this.cssEngine = cssEngine;
        this.locale = locale;
    }

    public FontManager getFontManager() {
        return this.fm;
    }

    public CSSEngine getCssEngine() {
        return this.cssEngine;
    }

    private boolean stylesEquivalent(BirtStyle style1, BirtStyle style2) {
        int i = 0;
        while (i < COMPARE_CSS_PROPERTIES.length) {
            CSSValue value2;
            int prop = COMPARE_CSS_PROPERTIES[i];
            CSSValue value1 = style1.getProperty(prop);
            if (!StyleManagerUtils.objectsEqual(value1, value2 = style2.getProperty(prop))) {
                return false;
            }
            ++i;
        }
        return StyleManagerUtils.objectsEqual(style1.getProperty(70), style2.getProperty(70)) && StyleManagerUtils.dataFormatsEquivalent((DataFormatValue)style1.getProperty(3), (DataFormatValue)style2.getProperty(3)) && FontManager.fontsEquivalent(style1, style2);
    }

    private CellStyle createStyle(BirtStyle birtStyle) {
        CellStyle poiStyle = this.workbook.createCellStyle();
        Font font = this.fm.getFont(birtStyle);
        if (font != null) {
            poiStyle.setFont(font);
        }
        HorizontalAlignment alignment = this.smu.poiAlignmentFromBirtAlignment(birtStyle.getString(39));
        poiStyle.setAlignment(alignment);
        this.smu.addBackgroundColourToStyle(this.workbook, poiStyle, birtStyle.getString(40));
        if (birtStyle.isTextIndentInUse() && alignment != null && !alignment.equals((Object)HorizontalAlignment.CENTER) && !alignment.equals((Object)HorizontalAlignment.CENTER_SELECTION)) {
            CSSValue paddingCSSValue;
            CSSValue marginCSSValue;
            short indent = 0;
            String marginCSS = "";
            String paddingCSS = "";
            if (alignment.equals((Object)HorizontalAlignment.RIGHT)) {
                marginCSSValue = birtStyle.getProperty(1);
                paddingCSSValue = birtStyle.getProperty(16);
            } else {
                marginCSSValue = birtStyle.getProperty(0);
                paddingCSSValue = birtStyle.getProperty(12);
            }
            marginCSS = marginCSSValue != null ? marginCSSValue.getCssText() : "0";
            paddingCSS = paddingCSSValue != null ? paddingCSSValue.getCssText() : "0";
            double marginIndent = this.smu.convertDimensionToMillimetres(DimensionType.parserUnit(marginCSS));
            double paddingIndent = this.smu.convertDimensionToMillimetres(DimensionType.parserUnit(paddingCSS));
            int tmpIndent = this.smu.poiIndentUnit(new DimensionType(marginIndent + paddingIndent, "mm"));
            indent = tmpIndent < 0 ? (short)0 : (tmpIndent > Short.MAX_VALUE ? (short)Short.MAX_VALUE : (short)tmpIndent);
            poiStyle.setIndention(indent);
        }
        if (this.smu instanceof StyleManagerXUtils) {
            this.smu.applyBorderStyle(this.workbook, poiStyle, birtStyle);
        } else {
            this.smu.applyBorderStyle(this.workbook, poiStyle, XSSFCellBorder.BorderSide.TOP, birtStyle.getProperty(24), birtStyle.getProperty(49), birtStyle.getProperty(27));
            this.smu.applyBorderStyle(this.workbook, poiStyle, XSSFCellBorder.BorderSide.LEFT, birtStyle.getProperty(47), birtStyle.getProperty(58), birtStyle.getProperty(50));
            this.smu.applyBorderStyle(this.workbook, poiStyle, XSSFCellBorder.BorderSide.RIGHT, birtStyle.getProperty(4), birtStyle.getProperty(20), birtStyle.getProperty(9));
            this.smu.applyBorderStyle(this.workbook, poiStyle, XSSFCellBorder.BorderSide.BOTTOM, birtStyle.getProperty(5), birtStyle.getProperty(21), birtStyle.getProperty(10));
        }
        this.smu.applyNumberFormat(this.workbook, birtStyle, poiStyle, this.locale);
        if ("pre".equals(birtStyle.getString(57))) {
            poiStyle.setWrapText(true);
        }
        if ("top".equals(birtStyle.getString(43))) {
            poiStyle.setVerticalAlignment(VerticalAlignment.TOP);
        } else if ("middle".equals(birtStyle.getString(43))) {
            poiStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        } else if ("bottom".equals(birtStyle.getString(43))) {
            poiStyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
        }
        CSSValue rotation = birtStyle.getProperty(70);
        if (rotation instanceof FloatValue) {
            poiStyle.setRotation((short)((FloatValue)rotation).getFloatValue());
        }
        this.styles.add(new StylePair(birtStyle.clone(), poiStyle));
        return poiStyle;
    }

    public CellStyle getStyle(BirtStyle birtStyle) {
        for (StylePair stylePair : this.styles) {
            if (!this.stylesEquivalent(birtStyle, stylePair.birtStyle)) continue;
            return stylePair.poiStyle;
        }
        return this.createStyle(birtStyle);
    }

    private BirtStyle birtStyleFromCellStyle(CellStyle source) {
        for (StylePair stylePair : this.styles) {
            if (!source.equals(stylePair.poiStyle)) continue;
            return stylePair.birtStyle.clone();
        }
        return new BirtStyle(this.cssEngine);
    }

    public CellStyle getStyleWithBorders(CellStyle source, CSSValue borderStyleBottom, CSSValue borderWidthBottom, CSSValue borderColourBottom, CSSValue borderStyleLeft, CSSValue borderWidthLeft, CSSValue borderColourLeft, CSSValue borderStyleRight, CSSValue borderWidthRight, CSSValue borderColourRight, CSSValue borderStyleTop, CSSValue borderWidthTop, CSSValue borderColourTop, CSSValue borderStyleDiagonal, CSSValue borderWidthDiagonal, CSSValue borderColourDiagonal, CSSValue borderStyleAntidiagonal, CSSValue borderWidthAntidiagonal, CSSValue borderColourAntidiagonal) {
        BirtStyle birtStyle = this.birtStyleFromCellStyle(source);
        if (borderStyleBottom != null && borderWidthBottom != null && borderColourBottom != null) {
            birtStyle.setProperty(21, borderStyleBottom);
            birtStyle.setProperty(10, borderWidthBottom);
            birtStyle.setProperty(5, borderColourBottom);
        }
        if (borderStyleLeft != null && borderWidthLeft != null && borderColourLeft != null) {
            birtStyle.setProperty(58, borderStyleLeft);
            birtStyle.setProperty(50, borderWidthLeft);
            birtStyle.setProperty(47, borderColourLeft);
        }
        if (borderStyleRight != null && borderWidthRight != null && borderColourRight != null) {
            birtStyle.setProperty(20, borderStyleRight);
            birtStyle.setProperty(9, borderWidthRight);
            birtStyle.setProperty(4, borderColourRight);
        }
        if (borderStyleTop != null && borderWidthTop != null && borderColourTop != null) {
            birtStyle.setProperty(49, borderStyleTop);
            birtStyle.setProperty(27, borderWidthTop);
            birtStyle.setProperty(24, borderColourTop);
        }
        if (borderStyleDiagonal != null && borderWidthDiagonal != null && borderColourDiagonal != null) {
            birtStyle.setProperty(22, borderStyleDiagonal);
            birtStyle.setProperty(11, borderWidthDiagonal);
            birtStyle.setProperty(7, borderColourDiagonal);
        }
        if (borderStyleAntidiagonal != null && borderWidthAntidiagonal != null && borderColourAntidiagonal != null) {
            birtStyle.setProperty(26, borderStyleAntidiagonal);
            birtStyle.setProperty(18, borderWidthAntidiagonal);
            birtStyle.setProperty(14, borderColourAntidiagonal);
        }
        CellStyle newStyle = this.getStyle(birtStyle);
        return newStyle;
    }

    public CellStyle getStyleWithExtraStyle(CellStyle source, IStyle birtExtraStyle) {
        BirtStyle birtStyle = this.birtStyleFromCellStyle(source);
        int i = 0;
        while (i < 71) {
            CSSValue value = birtExtraStyle.getProperty(i);
            if (value != null) {
                birtStyle.setProperty(i, value);
            }
            ++i;
        }
        CellStyle newStyle = this.getStyle(birtStyle);
        return newStyle;
    }

    private class StylePair {
        public BirtStyle birtStyle;
        public CellStyle poiStyle;

        public StylePair(BirtStyle birtStyle, CellStyle poiStyle) {
            this.birtStyle = birtStyle;
            this.poiStyle = poiStyle;
        }
    }
}

