/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.nLayout.area.IAreaVisitor;
import org.eclipse.birt.report.engine.nLayout.area.IImageArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.AbstractArea;

public class ImageArea
extends AbstractArea
implements IImageArea {
    protected String url;
    protected byte[] data;
    protected String extension;
    protected String helpText;
    protected String mimetype;
    protected HashMap<String, String> params;
    protected ArrayList<IImageArea.IImageMap> imageMapDescription;

    public ImageArea() {
    }

    public ImageArea(ImageArea area) {
        super(area);
        this.url = area.getImageUrl();
        this.data = area.getImageData();
        this.extension = area.extension;
        this.helpText = area.helpText;
        this.mimetype = area.mimetype;
        this.params = area.params;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    public void accept(IAreaVisitor visitor) {
        visitor.visitImage(this);
    }

    @Override
    public byte[] getImageData() {
        return this.data;
    }

    @Override
    public String getImageUrl() {
        return this.url;
    }

    @Override
    public AbstractArea cloneArea() {
        return new ImageArea(this);
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    @Override
    public String getHelpText() {
        return this.helpText;
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }

    @Override
    public String getMIMEType() {
        return this.mimetype;
    }

    public void setMIMEType(String mimetype) {
        this.mimetype = mimetype;
    }

    @Override
    public HashMap<String, String> getParameters() {
        return this.params;
    }

    public void setParameters(HashMap<String, String> params) {
        this.params = params;
    }

    @Override
    public void addImageMap(int[] peak, IHyperlinkAction action) {
        if (this.imageMapDescription == null) {
            this.imageMapDescription = new ArrayList();
        }
        ImageMap map = new ImageMap(peak, action);
        this.imageMapDescription.add(map);
    }

    @Override
    public ArrayList<IImageArea.IImageMap> getImageMapDescription() {
        return this.imageMapDescription;
    }

    static class ImageMap
    implements IImageArea.IImageMap {
        int[] vertices;
        IHyperlinkAction action;

        public ImageMap(int[] vertices, IHyperlinkAction action) {
            this.vertices = vertices;
            this.action = action;
        }

        @Override
        public int[] getVertices() {
            return this.vertices;
        }

        @Override
        public IHyperlinkAction getAction() {
            return this.action;
        }
    }
}

