/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.dup;

import java.util.HashMap;
import java.util.Stack;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.executor.DataItemExecutionState;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.DefaultReportItemVisitorImpl;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.ListingDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.TableBandDesign;
import org.eclipse.birt.report.engine.ir.TableGroupDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;

public class SuppressDuplicateUtil {
    private HashMap<DataItemDesign, DataItemExecutionState> states = new HashMap();
    private Report report;
    private ClearDuplicateFlagVisitor resetVisitor;

    public SuppressDuplicateUtil(Report report) {
        this.report = report;
        this.resetVisitor = new ClearDuplicateFlagVisitor();
    }

    public void clearDuplicateFlags(IContent content) {
        Object itemDesign = content.getGenerateBy();
        if (itemDesign instanceof GroupDesign) {
            GroupDesign groupDesign = (GroupDesign)itemDesign;
            ListingDesign listingDesign = this.getListingDesign(groupDesign);
            if (!this.isGroupEmpty(groupDesign)) {
                int groupLevel = groupDesign.getGroupLevel();
                int groupCount = listingDesign.getGroupCount();
                int i = groupLevel + 1;
                while (i < groupCount) {
                    GroupDesign group = listingDesign.getGroup(i);
                    group.accept(this.resetVisitor, null);
                    ++i;
                }
                BandDesign detail = listingDesign.getDetail();
                if (detail != null) {
                    detail.accept(this.resetVisitor, null);
                }
            }
        } else if (itemDesign instanceof ListingDesign) {
            ((ListingDesign)itemDesign).accept(this.resetVisitor, null);
        }
    }

    protected ListingDesign getListingDesign(GroupDesign groupDesign) {
        long listingId = groupDesign.getHandle().getContainer().getID();
        return (ListingDesign)this.report.getReportItemByID(listingId);
    }

    protected boolean isGroupEmpty(GroupDesign groupDesign) {
        BandDesign header = groupDesign.getHeader();
        BandDesign footer = groupDesign.getFooter();
        return (header == null || header.getContentCount() == 0) && (footer == null || footer.getContentCount() == 0);
    }

    public IContent suppressDuplicate(IContent content) throws BirtException {
        DataItemDesign dataDesign;
        int contentType = content.getContentType();
        if (contentType != 3) {
            return content;
        }
        IDataContent dataContent = (IDataContent)content;
        Object genBy = dataContent.getGenerateBy();
        if (genBy instanceof DataItemDesign && (dataDesign = (DataItemDesign)genBy).getSuppressDuplicate() && this.states.containsKey(dataDesign)) {
            Object lastValue;
            Object value = dataContent.getValue();
            DataItemExecutionState state = this.states.get(dataDesign);
            if (state != null && ((lastValue = state.lastValue) == value || lastValue != null && lastValue.equals(value))) {
                return null;
            }
            if (state == null) {
                state = new DataItemExecutionState();
                this.states.put(dataDesign, state);
            }
            state.lastValue = value;
        }
        return content;
    }

    private class ClearDuplicateFlagVisitor
    extends DefaultReportItemVisitorImpl {
        private Stack<Boolean> isInDetailBand = new Stack();

        private ClearDuplicateFlagVisitor() {
        }

        private boolean isBandEmpty(TableBandDesign band) {
            if (band != null) {
                int i = 0;
                while (i < band.getContentCount()) {
                    RowDesign row = (RowDesign)band.getContent(i);
                    int j = 0;
                    while (j < row.getCellCount()) {
                        CellDesign cell = row.getCell(j);
                        if (cell.getContentCount() > 0) {
                            return false;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            return true;
        }

        @Override
        public Object visitListing(ListingDesign list, Object value) {
            BandDesign footer;
            BandDesign header = list.getHeader();
            if (header != null) {
                value = header.accept(this, value);
            }
            int i = 0;
            while (i < list.getGroupCount()) {
                GroupDesign group = list.getGroup(i);
                value = group.accept(this, value);
                ++i;
            }
            BandDesign detail = list.getDetail();
            if (detail != null) {
                value = detail.accept(this, value);
            }
            if ((footer = list.getFooter()) != null) {
                value = footer.accept(this, value);
            }
            return value;
        }

        @Override
        public Object visitDataItem(DataItemDesign data, Object value) {
            if (!this.isInDetailBand.isEmpty() && this.isInDetailBand.peek().booleanValue()) {
                SuppressDuplicateUtil.this.states.put(data, null);
            }
            return value;
        }

        @Override
        public Object visitGridItem(GridItemDesign grid, Object value) {
            int i = 0;
            while (i < grid.getRowCount()) {
                value = grid.getRow(i).accept(this, value);
                ++i;
            }
            return value;
        }

        @Override
        public Object visitRow(RowDesign row, Object value) {
            int i = 0;
            while (i < row.getCellCount()) {
                value = this.visitCell(row.getCell(i), value);
                ++i;
            }
            return value;
        }

        @Override
        public Object visitCell(CellDesign cell, Object value) {
            int i = 0;
            while (i < cell.getContentCount()) {
                value = cell.getContent(i).accept(this, value);
                ++i;
            }
            return value;
        }

        private boolean isDetailGroupOfSummaryTable(TableBandDesign band) {
            TableGroupDesign group = (TableGroupDesign)band.getGroup();
            if (group == null) {
                return false;
            }
            TableItemDesign listingDesign = (TableItemDesign)SuppressDuplicateUtil.this.getListingDesign(group);
            if (!this.isBandEmpty((TableBandDesign)listingDesign.getDetail())) {
                return false;
            }
            int i = listingDesign.getGroupCount() - 1;
            while (i >= 0) {
                GroupDesign groupDesign = listingDesign.getGroup(i);
                if (!SuppressDuplicateUtil.this.isGroupEmpty(groupDesign)) {
                    return group == groupDesign;
                }
                --i;
            }
            return false;
        }

        private boolean isDetailBand(TableBandDesign band) {
            if (this.isBandEmpty(band)) {
                return false;
            }
            int bandType = band.getBandType();
            return bandType == 0 || this.isDetailGroupOfSummaryTable(band);
        }

        @Override
        public Object visitTableBand(TableBandDesign band, Object value) {
            boolean isDetail = this.isDetailBand(band);
            this.isInDetailBand.push(isDetail);
            int i = 0;
            while (i < band.getContentCount()) {
                value = band.getContent(i).accept(this, value);
                ++i;
            }
            this.isInDetailBand.pop();
            return value;
        }

        @Override
        public Object visitBand(BandDesign band, Object value) {
            int i = 0;
            while (i < band.getContentCount()) {
                value = band.getContent(i).accept(this, value);
                ++i;
            }
            return value;
        }

        @Override
        public Object visitGroup(GroupDesign group, Object value) {
            BandDesign footer;
            BandDesign header = group.getHeader();
            if (header != null) {
                value = header.accept(this, value);
            }
            if ((footer = group.getFooter()) != null) {
                value = footer.accept(this, value);
            }
            return value;
        }
    }
}

