/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.Iterator;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.ILineStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFAbstractLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFInlineStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;

public class PDFInlineContainerLM
extends PDFInlineStackingLM
implements ILineStackingLayoutManager {
    ILineStackingLayoutManager lineParent;
    int childHeight = 0;

    public PDFInlineContainerLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
        this.lineParent = (ILineStackingLayoutManager)((Object)parent);
    }

    @Override
    protected void closeLayout() {
        if (this.root != null) {
            this.root.setContentHeight(this.childHeight);
            IStyle areaStyle = this.root.getStyle();
            int width = this.getCurrentIP() + this.getOffsetX() + this.getDimensionValue(areaStyle.getProperty(16)) + this.getDimensionValue(areaStyle.getProperty(9));
            this.root.setWidth(width);
            int height = 0;
            Iterator<IArea> iter = this.root.getChildren();
            while (iter.hasNext()) {
                AbstractArea child = (AbstractArea)iter.next();
                height = Math.max(height, child.getAllocatedHeight());
            }
            this.root.setContentHeight(height);
        }
        this.verticalAlign();
    }

    @Override
    protected void createRoot() {
        this.root = (ContainerArea)AreaFactory.createInlineContainer(this.content);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected boolean traverseChildren() throws BirtException {
        hasNextPage = false;
        if (this.child == null || !(hasNextPage = this.child.layout())) ** GOTO lbl9
        if (this.child.isFinished()) {
            this.child = null;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            childExecutor = this.executor.getNextChild();
            if (childExecutor == null || !this.layoutChildNode(childExecutor)) continue;
            return true;
lbl9:
            // 2 sources

            ** while (this.executor.hasNextChild())
        }
lbl10:
        // 1 sources

        return false;
    }

    private boolean layoutChildNode(IReportItemExecutor childExecutor) throws BirtException {
        IContent childContent = childExecutor.execute();
        PDFAbstractLM childLM = this.getFactory().createLayoutManager(this, childContent, childExecutor);
        boolean hasNextPage = childLM.layout();
        this.child = hasNextPage && !childLM.isFinished() ? childLM : null;
        return hasNextPage;
    }

    @Override
    protected void initialize() {
        this.createRoot();
        this.maxAvaWidth = this.parent.getCurrentMaxContentWidth();
        this.maxAvaHeight = this.parent.getCurrentMaxContentHeight();
        this.currentBP = 0;
        this.currentIP = 0;
    }

    public int getTextIndent() {
        if (this.content != null) {
            IStyle contentStyle = this.content.getComputedStyle();
            return this.getDimensionValue(contentStyle.getProperty(29), this.maxAvaWidth);
        }
        return 0;
    }

    @Override
    public boolean addArea(IArea area, boolean keepWithPrevious, boolean keepWithNext) {
        AbstractArea child = (AbstractArea)area;
        this.submit(child);
        return true;
    }

    @Override
    public void submit(AbstractArea area) {
        this.root.addChild(area);
        area.setAllocatedPosition(this.getCurrentIP(), this.getCurrentBP());
        this.setCurrentIP(this.getCurrentIP() + area.getAllocatedWidth());
    }

    @Override
    public boolean endLine() {
        if (this.root != null && this.root.getChildrenCount() > 0) {
            this.closeLayout();
            this.parent.submit(this.root);
        }
        if (this.parent instanceof ILineStackingLayoutManager) {
            boolean ret = ((ILineStackingLayoutManager)((Object)this.parent)).endLine();
            if (ret) {
                this.initialize();
                return true;
            }
            return false;
        }
        assert (false);
        return true;
    }

    @Override
    public int getMaxLineWidth() {
        return this.lineParent.getMaxLineWidth();
    }

    @Override
    public boolean isEmptyLine() {
        if (this.root != null && this.root.getChildrenCount() > 0) {
            return false;
        }
        return this.lineParent.isEmptyLine();
    }

    @Override
    public void setTextIndent(ITextContent content) {
        if (this.parent instanceof ILineStackingLayoutManager) {
            ((ILineStackingLayoutManager)((Object)this.parent)).setTextIndent(content);
        }
    }
}

