/*
 * Decompiled with CFR 0.152.
 */
package eu.esu.mobilecontrol2.sdk;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.util.Log;
import eu.esu.mobilecontrol2.sdk.InputServices;
import eu.esu.mobilecontrol2.sdk.MobileControl2;
import java.lang.ref.WeakReference;

abstract class MessageServiceFragment
extends Fragment {
    private Messenger mSender;
    private Messenger mReceiver;
    private boolean mServiceBound;
    private final ServiceConnection mConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            MessageServiceFragment.this.mSender = new Messenger(service);
            Message register = Message.obtain(null, (int)1);
            register.replyTo = MessageServiceFragment.this.mReceiver;
            MessageServiceFragment.this.sendMessage(register);
            MessageServiceFragment.this.mServiceBound = true;
            MessageServiceFragment.this.onServiceConnected();
        }

        public void onServiceDisconnected(ComponentName name) {
            MessageServiceFragment.this.mServiceBound = false;
        }
    };

    MessageServiceFragment() {
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mReceiver = new Messenger((Handler)new IncomingMessageHandler(new WeakReference<MessageServiceFragment>(this)));
        if (MobileControl2.isMobileControl2() && InputServices.isInstalled((Context)this.getActivity())) {
            this.getActivity().bindService(this.getServiceIntent(), this.mConnection, 1);
        }
    }

    public void onDestroy() {
        if (this.mServiceBound) {
            Message message = Message.obtain(null, (int)2);
            message.replyTo = this.mReceiver;
            this.sendMessage(message);
            this.getActivity().unbindService(this.mConnection);
        }
        super.onDestroy();
    }

    protected boolean isServiceBound() {
        return this.mServiceBound;
    }

    protected abstract Intent getServiceIntent();

    protected void sendMessage(Message message) {
        try {
            this.mSender.send(message);
        }
        catch (RemoteException ex) {
            Log.e((String)"EsuInputServices", (String)"Failed to send message", (Throwable)ex);
        }
    }

    protected void onServiceConnected() {
    }

    protected void onMessageReceived(Message message) {
    }

    private static class IncomingMessageHandler
    extends Handler {
        private final WeakReference<MessageServiceFragment> mParent;

        public IncomingMessageHandler(WeakReference<MessageServiceFragment> parent) {
            this.mParent = parent;
        }

        public void handleMessage(Message msg) {
            MessageServiceFragment parent = (MessageServiceFragment)((Object)this.mParent.get());
            if (parent == null) {
                throw new AssertionError((Object)"parent is null");
            }
            if (parent.isResumed()) {
                parent.onMessageReceived(msg);
            }
        }
    }
}

