/*
 * Decompiled with CFR 0.152.
 */
package eu.esu.mobilecontrol2.sdk;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.util.Log;
import eu.esu.mobilecontrol2.sdk.OnThrottleListener;
import eu.esu.mobilecontrol2.sdk.Throttle;
import java.lang.ref.WeakReference;

@TargetApi(value=12)
public class ThrottleFragment
extends Fragment {
    public static final int KEYCODE_THROTTLE_WAKEUP = 203;
    private static final String TAG = "Mobile Control II Throttle";
    private Messenger mReceiver;
    private Messenger mSender;
    private boolean mThrottleBound;
    private int mZeroPosition;
    private final ServiceConnection mConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            ThrottleFragment.this.mSender = new Messenger(service);
            Message msgRegister = Message.obtain(null, (int)1);
            msgRegister.replyTo = ThrottleFragment.this.mReceiver;
            ThrottleFragment.this.sendMessage(msgRegister);
            ThrottleFragment.this.sendMessage(Message.obtain(null, (int)4, (int)ThrottleFragment.this.mZeroPosition, (int)0));
            ThrottleFragment.this.mThrottleBound = true;
        }

        public void onServiceDisconnected(ComponentName name) {
            Log.w((String)ThrottleFragment.TAG, (String)"Throttle service disconnected");
            ThrottleFragment.this.mThrottleBound = false;
        }
    };
    private OnThrottleListener mOnThrottleListener;

    public static ThrottleFragment newInstance(int zeroPosition) {
        Bundle args = new Bundle();
        args.putInt("zeroPosition", ThrottleFragment.checkPosition(zeroPosition));
        ThrottleFragment fragment = new ThrottleFragment();
        fragment.setArguments(args);
        return fragment;
    }

    private static int checkPosition(int position) {
        if (position < 0 || position > 255) {
            throw new IllegalArgumentException("position must be >= 0 and <= 255");
        }
        return position;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mZeroPosition = this.getArguments().getInt("zeroPosition", 0);
        this.mReceiver = new Messenger((Handler)new IncomingMessageHandler(new WeakReference<ThrottleFragment>(this)));
        if (Throttle.isInstalled((Context)this.getActivity())) {
            Log.d((String)TAG, (String)"Found Mobile Control II Throttle, binding service.");
            Intent intent = new Intent("eu.esu.mobilecontrol2.throttle.SERVICE");
            this.getActivity().bindService(intent, this.mConnection, 1);
        }
    }

    public void onDestroy() {
        if (this.mThrottleBound) {
            Log.d((String)TAG, (String)"Mobile Control II Throttle no longer needed, unbinding service.");
            Message msg = Message.obtain(null, (int)2);
            msg.replyTo = this.mReceiver;
            this.sendMessage(msg);
            this.getActivity().unbindService(this.mConnection);
        }
        super.onDestroy();
    }

    public void moveThrottle(int position) {
        if (this.mThrottleBound) {
            Message msg = Message.obtain(null, (int)3, (int)ThrottleFragment.checkPosition(position), (int)0);
            this.sendMessage(msg);
        }
    }

    public void setOnThrottleListener(OnThrottleListener listener) {
        this.mOnThrottleListener = listener;
    }

    private void sendMessage(Message msg) {
        try {
            this.mSender.send(msg);
        }
        catch (RemoteException ex) {
            Log.e((String)TAG, (String)"Message not sent to throttle.", (Throwable)ex);
        }
    }

    private static class IncomingMessageHandler
    extends Handler {
        private final WeakReference<ThrottleFragment> mParent;

        public IncomingMessageHandler(WeakReference<ThrottleFragment> parent) {
            if (parent == null) {
                throw new NullPointerException("parent is null");
            }
            this.mParent = parent;
        }

        public void handleMessage(Message msg) {
            ThrottleFragment parent = (ThrottleFragment)((Object)this.mParent.get());
            if (parent == null) {
                throw new NullPointerException();
            }
            OnThrottleListener listener = parent.mOnThrottleListener;
            if (listener != null) {
                switch (msg.what) {
                    case 6: {
                        listener.onButtonDown();
                        break;
                    }
                    case 7: {
                        listener.onButtonUp();
                        break;
                    }
                    case 5: {
                        listener.onPositionChanged(msg.arg1);
                        break;
                    }
                    default: {
                        super.handleMessage(msg);
                        break;
                    }
                }
            } else {
                super.handleMessage(msg);
            }
        }
    }
}

