/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.viewholders;

import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import eu.davidea.flexibleadapter.FlexibleAdapter;

abstract class ContentViewHolder
extends RecyclerView.ViewHolder {
    private int mBackupPosition = -1;
    private View contentView;

    ContentViewHolder(View view, FlexibleAdapter adapter, boolean stickyHeader) {
        super((View)(stickyHeader ? new FrameLayout(view.getContext()) : view));
        if (stickyHeader) {
            this.itemView.setLayoutParams((ViewGroup.LayoutParams)adapter.getRecyclerView().getLayoutManager().generateLayoutParams(view.getLayoutParams()));
            ((FrameLayout)this.itemView).addView(view);
            float elevation = ViewCompat.getElevation((View)view);
            if (elevation > 0.0f) {
                ViewCompat.setBackground((View)this.itemView, (Drawable)view.getBackground());
                ViewCompat.setElevation((View)this.itemView, (float)elevation);
            }
            this.contentView = view;
        }
    }

    public final View getContentView() {
        return this.contentView != null ? this.contentView : this.itemView;
    }

    public final int getFlexibleAdapterPosition() {
        int position = this.getAdapterPosition();
        if (position == -1) {
            position = this.mBackupPosition;
        }
        return position;
    }

    public final void setBackupPosition(int backupPosition) {
        this.mBackupPosition = backupPosition;
    }
}

